/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.test;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import net.opengis.sensorml.v20.AbstractProcess;
import net.opengis.swe.v20.DataBlock;
import net.opengis.swe.v20.DataComponent;
import org.junit.Assert;
import org.vast.sensorML.SMLUtils;
import org.vast.swe.SWEUtils;

public class TestUtils {
    public static void assertEquals(DataComponent comp1, DataComponent comp2) throws Exception {
        SWEUtils sweUtils = new SWEUtils("2.0");
        ByteArrayOutputStream os1 = new ByteArrayOutputStream(1024);
        sweUtils.writeComponent((OutputStream)os1, comp1, true, false);
        byte[] buf1 = os1.toByteArray();
        ByteArrayOutputStream os2 = new ByteArrayOutputStream(1024);
        sweUtils.writeComponent((OutputStream)os2, comp2, true, false);
        byte[] buf2 = os2.toByteArray();
        Assert.assertTrue((String)"Data components are not equal", (boolean)Arrays.equals(buf1, buf2));
    }

    public static void assertEquals(DataBlock data1, DataBlock data2) throws Exception {
        Assert.assertEquals((String)"Data blocks are not the same size", (long)data1.getAtomCount(), (long)data2.getAtomCount());
        for (int i = 0; i < data1.getAtomCount(); ++i) {
            Assert.assertEquals((String)("Data blocks values are not equal at index=" + i), (Object)data1.getStringValue(i), (Object)data2.getStringValue(i));
        }
    }

    public static void assertEquals(AbstractProcess p1, AbstractProcess p2) throws Exception {
        SMLUtils smlUtils = new SMLUtils("2.0");
        ByteArrayOutputStream os1 = new ByteArrayOutputStream(1024);
        smlUtils.writeProcess((OutputStream)os1, p1, false);
        byte[] buf1 = os1.toByteArray();
        ByteArrayOutputStream os2 = new ByteArrayOutputStream(1024);
        smlUtils.writeProcess((OutputStream)os2, p2, false);
        byte[] buf2 = os2.toByteArray();
        Assert.assertTrue((String)"SensorML descriptions are not equal", (boolean)Arrays.equals(buf1, buf2));
    }
}

