/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.test.comm;

import java.net.UnknownHostException;
import org.junit.Assert;
import org.junit.Test;
import org.sensorhub.impl.comm.IPNetworkUtils;

public class TestIpNetworkUtils {
    @Test
    public void testResolveValidHost() throws Exception {
        int timeOut = 10000;
        long t0 = System.currentTimeMillis();
        IPNetworkUtils.resolveHost((String)"www.google.com", (int)timeOut);
        long t1 = System.currentTimeMillis();
        Assert.assertTrue((String)"DNS resolution timeout expired", (t1 - t0 < (long)timeOut ? 1 : 0) != 0);
    }

    @Test
    public void testResolveInvalidHost() throws Exception {
        int timeOut = 1000;
        try {
            long t0 = System.currentTimeMillis();
            IPNetworkUtils.resolveHost((String)"fdazdaztger", (int)timeOut);
            long t1 = System.currentTimeMillis();
            Assert.assertTrue((String)"DNS resolution timeout should have expired", (t1 - t0 >= (long)timeOut ? 1 : 0) != 0);
        }
        catch (UnknownHostException e) {
            return;
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected Exception: " + e.getMessage()));
        }
        Assert.fail((String)"Host should not be reachable");
    }

    @Test
    public void testPingLocalHost() throws Exception {
        int timeOut = 10000;
        long t0 = System.currentTimeMillis();
        boolean reachable = IPNetworkUtils.isHostReachable((String)"localhost", (int)timeOut);
        long t1 = System.currentTimeMillis();
        Assert.assertTrue((String)"Timeout expired", (t1 - t0 < (long)timeOut ? 1 : 0) != 0);
        Assert.assertTrue((String)"Localhost is not reachable", (boolean)reachable);
    }

    @Test
    public void testPingInvalidHost() throws Exception {
        int timeOut = 100;
        boolean reachable = IPNetworkUtils.isHostReachable((String)"172.1.1.1", (int)timeOut);
        Assert.assertFalse((String)"Invalid host should not be reachable", (boolean)reachable);
    }
}

