/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.test.module;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.sensorhub.api.common.Event;
import org.sensorhub.api.common.IEventListener;
import org.sensorhub.api.common.SensorHubException;
import org.sensorhub.api.module.IModule;
import org.sensorhub.api.module.ModuleEvent;
import org.sensorhub.impl.SensorHub;
import org.sensorhub.impl.module.AbstractModule;
import org.sensorhub.impl.module.ModuleRegistry;
import org.sensorhub.test.module.AsyncModuleConfig;
import org.sensorhub.utils.MsgUtils;

public class AsyncModule
extends AbstractModule<AsyncModuleConfig>
implements IEventListener {
    ModuleRegistry registry = SensorHub.getInstance().getModuleRegistry();
    ExecutorService exec = Executors.newSingleThreadExecutor();

    public void requestInit(boolean force) throws SensorHubException {
        if (this.canInit(force)) {
            Callable<Void> task = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        if (((AsyncModuleConfig)((AsyncModule)AsyncModule.this).config).moduleIDNeededForInit != null) {
                            AbstractModule module = (AbstractModule)AsyncModule.this.registry.getModuleById(((AsyncModuleConfig)((AsyncModule)AsyncModule.this).config).moduleIDNeededForInit);
                            if (!((AsyncModuleConfig)((AsyncModule)AsyncModule.this).config).useWaitLoopForInit) {
                                SensorHub.getInstance().getEventBus().registerListener(((AsyncModuleConfig)((AsyncModule)AsyncModule.this).config).moduleIDNeededForInit, "_MAIN", (IEventListener)AsyncModule.this);
                                return null;
                            }
                            module.waitForState(((AsyncModuleConfig)((AsyncModule)AsyncModule.this).config).moduleStateNeededForInit, 0L);
                        }
                        try {
                            Thread.sleep(((AsyncModuleConfig)((AsyncModule)AsyncModule.this).config).initDelay);
                        }
                        catch (InterruptedException module) {
                            // empty catch block
                        }
                        AsyncModule.this.init();
                        return null;
                    }
                    catch (Exception e) {
                        AsyncModule.this.reportError("Error during init", e);
                        throw e;
                    }
                }
            };
            try {
                if (((AsyncModuleConfig)this.config).useThreadForInit) {
                    this.exec.submit(task);
                } else {
                    task.call();
                }
            }
            catch (Exception e) {
                throw new SensorHubException(e.getMessage(), e.getCause());
            }
        }
    }

    public void init() throws SensorHubException {
        System.out.println("Running init() of " + MsgUtils.moduleString((IModule)this));
        try {
            Thread.sleep(((AsyncModuleConfig)this.config).initExecTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setState(ModuleEvent.ModuleState.INITIALIZED);
    }

    public void requestStart() throws SensorHubException {
        if (this.canStart()) {
            Callable<Void> task = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        if (((AsyncModuleConfig)((AsyncModule)AsyncModule.this).config).moduleIDNeededForStart != null) {
                            AbstractModule module = (AbstractModule)AsyncModule.this.registry.getModuleById(((AsyncModuleConfig)((AsyncModule)AsyncModule.this).config).moduleIDNeededForStart);
                            if (!((AsyncModuleConfig)((AsyncModule)AsyncModule.this).config).useWaitLoopForStart) {
                                SensorHub.getInstance().getEventBus().registerListener(((AsyncModuleConfig)((AsyncModule)AsyncModule.this).config).moduleIDNeededForStart, "_MAIN", (IEventListener)AsyncModule.this);
                                return null;
                            }
                            module.waitForState(((AsyncModuleConfig)((AsyncModule)AsyncModule.this).config).moduleStateNeededForStart, 0L);
                        }
                        try {
                            Thread.sleep(((AsyncModuleConfig)((AsyncModule)AsyncModule.this).config).startDelay);
                        }
                        catch (InterruptedException module) {
                            // empty catch block
                        }
                        AsyncModule.this.start();
                        return null;
                    }
                    catch (Exception e) {
                        AsyncModule.this.reportError("Error during start", e);
                        throw e;
                    }
                }
            };
            try {
                if (((AsyncModuleConfig)this.config).useThreadForStart) {
                    this.exec.submit(task);
                } else {
                    task.call();
                }
            }
            catch (Exception e) {
                throw new SensorHubException(e.getMessage(), e.getCause());
            }
        }
    }

    public void start() throws SensorHubException {
        System.out.println("Running start() of " + MsgUtils.moduleString((IModule)this));
        try {
            Thread.sleep(((AsyncModuleConfig)this.config).startExecTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setState(ModuleEvent.ModuleState.STARTED);
    }

    public void requestStop() throws SensorHubException {
        if (this.canStop()) {
            Callable<Void> task = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        try {
                            Thread.sleep(((AsyncModuleConfig)((AsyncModule)AsyncModule.this).config).stopDelay);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        AsyncModule.this.stop();
                        return null;
                    }
                    catch (Exception e) {
                        AsyncModule.this.reportError("Error during stop", e);
                        throw e;
                    }
                }
            };
            try {
                if (((AsyncModuleConfig)this.config).useThreadForStop) {
                    this.exec.submit(task);
                } else {
                    task.call();
                }
            }
            catch (Exception e) {
                throw new SensorHubException(e.getMessage(), e.getCause());
            }
        }
    }

    public void stop() throws SensorHubException {
        System.out.println("Running stop() of " + MsgUtils.moduleString((IModule)this));
        try {
            Thread.sleep(((AsyncModuleConfig)this.config).stopExecTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setState(ModuleEvent.ModuleState.STOPPED);
    }

    public void handleEvent(Event<?> e) {
        if (e instanceof ModuleEvent) {
            switch ((ModuleEvent.Type)((ModuleEvent)e).getType()) {
                case STATE_CHANGED: {
                    IModule module = (IModule)e.getSource();
                    String moduleID = module.getLocalID();
                    ModuleEvent.ModuleState state = module.getCurrentState();
                    if (moduleID.equals(((AsyncModuleConfig)this.config).moduleIDNeededForInit) && state == ((AsyncModuleConfig)this.config).moduleStateNeededForInit) {
                        try {
                            this.init(this.config);
                        }
                        catch (SensorHubException e1) {
                            this.reportError("Cannot init module", e1);
                        }
                        break;
                    }
                    if (!moduleID.equals(((AsyncModuleConfig)this.config).moduleIDNeededForStart) || state != ((AsyncModuleConfig)this.config).moduleStateNeededForStart) break;
                    try {
                        this.start();
                    }
                    catch (SensorHubException e1) {
                        this.reportError("Cannot start module", e1);
                    }
                    break;
                }
            }
        }
    }

    public void cleanup() throws SensorHubException {
    }
}

