/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.test.module;

import org.junit.Assert;
import org.junit.Test;
import org.sensorhub.api.common.Event;
import org.sensorhub.api.common.IEventListener;
import org.sensorhub.api.module.ModuleEvent;
import org.sensorhub.test.module.AsyncModule;
import org.sensorhub.test.module.AsyncModuleConfig;

public class TestAsyncModule {
    private AsyncModule loadModule(final AsyncModuleConfig conf) {
        AsyncModule module = new AsyncModule();
        module.setConfiguration(conf);
        module.registerListener(new IEventListener(){

            public void handleEvent(Event<?> e) {
                switch (((ModuleEvent)e).getNewState()) {
                    case INITIALIZED: {
                        conf.initEventReceived = true;
                        break;
                    }
                    case STARTED: {
                        conf.startEventReceived = true;
                        break;
                    }
                    case STOPPED: {
                        conf.stopEventReceived = true;
                        break;
                    }
                }
            }
        });
        return module;
    }

    @Test
    public void testAsyncInit() throws Exception {
        AsyncModuleConfig conf = new AsyncModuleConfig();
        conf.moduleClass = AsyncModule.class.getCanonicalName();
        conf.id = "MOD_ASYNC2";
        conf.autoStart = false;
        conf.name = "ModuleAsync2";
        conf.useThreadForInit = true;
        conf.initDelay = 100L;
        conf.initExecTime = 200L;
        long timeOut = 5000L;
        AsyncModule module = this.loadModule(conf);
        module.requestInit(false);
        long t0 = System.currentTimeMillis();
        module.waitForState(ModuleEvent.ModuleState.INITIALIZED, timeOut);
        long t1 = System.currentTimeMillis();
        long expectedDelay = conf.initDelay + conf.initExecTime;
        long delay = t1 - t0;
        Assert.assertTrue((String)"Init never executed", (delay >= expectedDelay ? 1 : 0) != 0);
        Assert.assertTrue((String)"Init timeout reached", (delay < timeOut ? 1 : 0) != 0);
    }

    @Test
    public void testAsyncStart() throws Exception {
        AsyncModuleConfig conf = new AsyncModuleConfig();
        conf.moduleClass = AsyncModule.class.getCanonicalName();
        conf.id = "MOD_ASYNC2";
        conf.autoStart = false;
        conf.name = "ModuleAsync2";
        conf.useThreadForInit = true;
        conf.useThreadForStart = true;
        conf.initDelay = 100L;
        conf.initExecTime = 150L;
        conf.startDelay = 50L;
        conf.startExecTime = 100L;
        long timeOut = 5000L;
        AsyncModule module = this.loadModule(conf);
        module.requestInit(false);
        module.requestStart();
        long t0 = System.currentTimeMillis();
        module.waitForState(ModuleEvent.ModuleState.INITIALIZED, timeOut);
        long t1 = System.currentTimeMillis();
        module.waitForState(ModuleEvent.ModuleState.STARTED, timeOut);
        long t2 = System.currentTimeMillis();
        long expectedDelay = conf.initDelay + conf.initExecTime;
        long delay = t1 - t0;
        Assert.assertTrue((String)"Init never executed", (delay >= expectedDelay ? 1 : 0) != 0);
        Assert.assertTrue((String)"Init timeout reached", (delay < timeOut ? 1 : 0) != 0);
        expectedDelay = conf.startDelay + conf.startExecTime;
        delay = t2 - t1;
        Assert.assertTrue((String)"Start never executed", (delay >= expectedDelay ? 1 : 0) != 0);
        Assert.assertTrue((String)"Start timeout reached", (delay < timeOut ? 1 : 0) != 0);
    }

    @Test
    public void testAsyncStop() throws Exception {
        AsyncModuleConfig conf = new AsyncModuleConfig();
        conf.moduleClass = AsyncModule.class.getCanonicalName();
        conf.id = "MOD_ASYNC2";
        conf.autoStart = false;
        conf.name = "ModuleAsync2";
        conf.useThreadForInit = true;
        conf.useThreadForStart = true;
        conf.stopDelay = 50L;
        conf.stopExecTime = 100L;
        conf.useThreadForStop = true;
        long timeOut = 5000L;
        AsyncModule module = this.loadModule(conf);
        module.init();
        Assert.assertEquals((String)"Module was not initialized", (Object)ModuleEvent.ModuleState.INITIALIZED, (Object)module.getCurrentState());
        module.start();
        Assert.assertEquals((String)"Module was not started", (Object)ModuleEvent.ModuleState.STARTED, (Object)module.getCurrentState());
        long t0 = System.currentTimeMillis();
        module.requestStop();
        Assert.assertEquals((String)"Module is not stopping", (Object)ModuleEvent.ModuleState.STOPPING, (Object)module.getCurrentState());
        module.waitForState(ModuleEvent.ModuleState.STOPPED, timeOut);
        long t1 = System.currentTimeMillis();
        Assert.assertEquals((String)"Module was not stopped", (Object)ModuleEvent.ModuleState.STOPPED, (Object)module.getCurrentState());
        long expectedDelay = conf.stopDelay + conf.stopExecTime;
        long delay = t1 - t0;
        Assert.assertTrue((String)"Stop never executed", (delay >= expectedDelay ? 1 : 0) != 0);
        Assert.assertTrue((String)"Stop timeout reached", (delay < timeOut ? 1 : 0) != 0);
    }

    @Test
    public void testAsyncRestart() throws Exception {
        AsyncModuleConfig conf = new AsyncModuleConfig();
        conf.moduleClass = AsyncModule.class.getCanonicalName();
        conf.id = "MOD_ASYNC2";
        conf.autoStart = false;
        conf.name = "ModuleAsync2";
        conf.initDelay = 500L;
        conf.initExecTime = 500L;
        conf.startDelay = 50L;
        conf.startExecTime = 100L;
        long timeOut = 5000L;
        AsyncModule module = this.loadModule(conf);
        module.init();
        module.requestStart();
        module.waitForState(ModuleEvent.ModuleState.STARTED, timeOut);
        Assert.assertEquals((String)"Module was not started", (Object)ModuleEvent.ModuleState.STARTED, (Object)module.getCurrentState());
        conf.startEventReceived = false;
        long t0 = System.currentTimeMillis();
        module.requestStop();
        module.requestStart();
        module.waitForState(ModuleEvent.ModuleState.STARTED, timeOut);
        long t1 = System.currentTimeMillis();
        long expectedDelay = conf.startDelay + conf.startExecTime;
        long delay = t1 - t0;
        Assert.assertTrue((String)"Start never executed", (delay >= expectedDelay ? 1 : 0) != 0);
        Assert.assertTrue((String)"Start timeout reached", (delay < timeOut ? 1 : 0) != 0);
    }

    @Test
    public void testAsyncInitTimeout() throws Exception {
        AsyncModuleConfig conf = new AsyncModuleConfig();
        conf.moduleClass = AsyncModule.class.getCanonicalName();
        conf.id = "MOD_ASYNC2";
        conf.autoStart = false;
        conf.name = "ModuleAsync2";
        conf.useThreadForInit = true;
        conf.initDelay = 100L;
        conf.initExecTime = 200L;
        long timeOut = 100L;
        AsyncModule module = this.loadModule(conf);
        module.requestInit(false);
        boolean noTimeOut = module.waitForState(ModuleEvent.ModuleState.INITIALIZED, timeOut);
        Assert.assertFalse((String)"Init should have timeout", (boolean)noTimeOut);
    }

    @Test
    public void testAsyncInitCalledTwice() throws Exception {
        AsyncModuleConfig conf = new AsyncModuleConfig();
        conf.moduleClass = AsyncModule.class.getCanonicalName();
        conf.id = "MOD_ASYNC2";
        conf.autoStart = false;
        conf.name = "ModuleAsync2";
        conf.initDelay = 50L;
        conf.initExecTime = 100L;
        AsyncModule module = this.loadModule(conf);
        module.init();
        long t0 = System.currentTimeMillis();
        module.requestInit(false);
        Assert.assertEquals((String)"Module should remain initialized", (Object)ModuleEvent.ModuleState.INITIALIZED, (Object)module.getCurrentState());
        long t1 = System.currentTimeMillis();
        long delay = t1 - t0;
        Assert.assertFalse((String)"Init executed twice", (delay >= conf.initExecTime ? 1 : 0) != 0);
    }

    @Test
    public void testAsyncInitCalledWhileInitializing() throws Exception {
        AsyncModuleConfig conf = new AsyncModuleConfig();
        conf.moduleClass = AsyncModule.class.getCanonicalName();
        conf.id = "MOD_ASYNC2";
        conf.autoStart = false;
        conf.name = "ModuleAsync2";
        conf.initDelay = 500L;
        conf.initExecTime = 100L;
        conf.useThreadForInit = true;
        long timeOut = 5000L;
        AsyncModule module = this.loadModule(conf);
        long t0 = System.currentTimeMillis();
        module.requestInit(false);
        Assert.assertEquals((String)"Module should be initializing", (Object)ModuleEvent.ModuleState.INITIALIZING, (Object)module.getCurrentState());
        module.requestInit(false);
        Assert.assertEquals((String)"Module should remain initializing", (Object)ModuleEvent.ModuleState.INITIALIZING, (Object)module.getCurrentState());
        module.waitForState(ModuleEvent.ModuleState.INITIALIZED, timeOut);
        long t1 = System.currentTimeMillis();
        long expectedDelay = conf.initExecTime + conf.initDelay;
        long delay = t1 - t0;
        Assert.assertFalse((String)"Init executed twice", (delay >= 2L * expectedDelay ? 1 : 0) != 0);
        Assert.assertEquals((String)"Module was not initialized", (Object)ModuleEvent.ModuleState.INITIALIZED, (Object)module.getCurrentState());
    }

    @Test
    public void testAsyncStartCalledTwice() throws Exception {
        AsyncModuleConfig conf = new AsyncModuleConfig();
        conf.moduleClass = AsyncModule.class.getCanonicalName();
        conf.id = "MOD_ASYNC2";
        conf.autoStart = false;
        conf.name = "ModuleAsync2";
        conf.startDelay = 50L;
        conf.startExecTime = 100L;
        long timeOut = 2000L;
        AsyncModule module = this.loadModule(conf);
        module.init();
        module.requestStart();
        module.waitForState(ModuleEvent.ModuleState.STARTED, timeOut);
        Assert.assertEquals((String)"Module was not started", (Object)ModuleEvent.ModuleState.STARTED, (Object)module.getCurrentState());
        long t0 = System.currentTimeMillis();
        module.requestStart();
        Assert.assertEquals((String)"Module should remain started", (Object)ModuleEvent.ModuleState.STARTED, (Object)module.getCurrentState());
        long t1 = System.currentTimeMillis();
        long delay = t1 - t0;
        Assert.assertFalse((String)"Start executed twice", (delay >= conf.startExecTime ? 1 : 0) != 0);
    }

    @Test
    public void testAsyncStartCalledWhileInitializing() throws Exception {
        AsyncModuleConfig conf = new AsyncModuleConfig();
        conf.moduleClass = AsyncModule.class.getCanonicalName();
        conf.id = "MOD_ASYNC2";
        conf.autoStart = false;
        conf.name = "ModuleAsync2";
        conf.initDelay = 120L;
        conf.initExecTime = 100L;
        conf.useThreadForInit = true;
        conf.startDelay = 150L;
        conf.startExecTime = 70L;
        conf.useThreadForStart = true;
        long timeOut = 2000L;
        AsyncModule module = this.loadModule(conf);
        long t0 = System.currentTimeMillis();
        module.requestInit(false);
        Assert.assertEquals((String)"Module should be initializing", (Object)ModuleEvent.ModuleState.INITIALIZING, (Object)module.getCurrentState());
        module.requestStart();
        Assert.assertEquals((String)"Module should remain initializing", (Object)ModuleEvent.ModuleState.INITIALIZING, (Object)module.getCurrentState());
        module.waitForState(ModuleEvent.ModuleState.INITIALIZED, timeOut);
        long t1 = System.currentTimeMillis();
        module.waitForState(ModuleEvent.ModuleState.STARTED, timeOut);
        long t2 = System.currentTimeMillis();
        Assert.assertEquals((String)"Module was not started", (Object)ModuleEvent.ModuleState.STARTED, (Object)module.getCurrentState());
        long expectedDelay = conf.initExecTime + conf.initDelay;
        long delay = t1 - t0;
        Assert.assertFalse((String)"Init executed twice", (delay >= 2L * expectedDelay ? 1 : 0) != 0);
        Assert.assertTrue((String)"Init timeout reached", (delay < timeOut ? 1 : 0) != 0);
        expectedDelay = conf.startExecTime + conf.startDelay;
        delay = t2 - t1;
        Assert.assertTrue((String)"Start never executed", (delay >= expectedDelay ? 1 : 0) != 0);
        Assert.assertTrue((String)"Start timeout reached", (delay < timeOut ? 1 : 0) != 0);
    }
}

