/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.test.module;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sensorhub.api.module.ModuleConfig;
import org.sensorhub.api.persistence.StorageConfig;
import org.sensorhub.api.processing.ProcessConfig;
import org.sensorhub.api.sensor.SensorConfig;
import org.sensorhub.api.service.ServiceConfig;
import org.sensorhub.impl.module.ModuleConfigJsonFile;

public class TestModuleConfigJsonFile {
    ModuleConfigJsonFile configDb;
    File configFile;

    @Before
    public void setup() throws Exception {
        this.configFile = new File("test-conf.json");
        this.configFile.deleteOnExit();
        FileUtils.copyURLToFile((URL)TestModuleConfigJsonFile.class.getResource("/module-config.json"), (File)this.configFile);
        this.configDb = new ModuleConfigJsonFile(this.configFile.getAbsolutePath());
    }

    @Test
    public void testAdd() throws Exception {
        SensorConfig config1 = new SensorConfig();
        config1.id = UUID.randomUUID().toString();
        config1.name = "Sensor1";
        config1.moduleClass = "org.sensorhub.sensor.***";
        this.configDb.add(new ModuleConfig[]{config1});
        this.displayFile();
    }

    @Test(expected=RuntimeException.class)
    public void testAddAndRemove() throws Exception {
        SensorConfig config1 = new SensorConfig();
        config1.id = UUID.randomUUID().toString();
        config1.name = "Sensor1";
        config1.moduleClass = "org.sensorhub.sensor.***";
        this.configDb.add(new ModuleConfig[]{config1});
        this.displayFile();
        this.configDb.remove(new String[]{config1.id});
        this.configDb.get(config1.id);
    }

    @Test
    public void testAddAndReadBack() throws Exception {
        ProcessConfig config1 = new ProcessConfig();
        config1.id = UUID.randomUUID().toString();
        config1.name = "Process1";
        config1.moduleClass = "org.sensorhub.process.ProcessModel";
        this.configDb.add(new ModuleConfig[]{config1});
        ServiceConfig config2 = new ServiceConfig();
        config2.id = UUID.randomUUID().toString();
        config2.name = "Service1";
        config2.moduleClass = "org.sensorhub.service.SosService";
        this.configDb.add(new ModuleConfig[]{config2});
        ServiceConfig config3 = new ServiceConfig();
        config3.id = UUID.randomUUID().toString();
        config3.name = "Service2";
        config3.moduleClass = "org.sensorhub.service.SpsService";
        this.configDb.add(new ModuleConfig[]{config3});
        StorageConfig config4 = new StorageConfig();
        config4.id = UUID.randomUUID().toString();
        config4.name = "DB1";
        config4.moduleClass = "org.sensorhub.persistence.FeatureStorage";
        this.configDb.add(new ModuleConfig[]{config4});
        this.configDb.close();
        this.configDb = new ModuleConfigJsonFile(this.configFile.getAbsolutePath());
        ModuleConfig storedConf = this.configDb.get(config1.id);
        Assert.assertTrue((boolean)storedConf.id.equals(config1.id));
        Assert.assertTrue((boolean)storedConf.name.equals(config1.name));
        Assert.assertTrue((boolean)storedConf.moduleClass.equals(config1.moduleClass));
        storedConf = this.configDb.get(config2.id);
        Assert.assertTrue((boolean)storedConf.id.equals(config2.id));
        Assert.assertTrue((boolean)storedConf.name.equals(config2.name));
        Assert.assertTrue((boolean)storedConf.moduleClass.equals(config2.moduleClass));
        storedConf = this.configDb.get(config3.id);
        Assert.assertTrue((boolean)storedConf.id.equals(config3.id));
        Assert.assertTrue((boolean)storedConf.name.equals(config3.name));
        Assert.assertTrue((boolean)storedConf.moduleClass.equals(config3.moduleClass));
        storedConf = this.configDb.get(config4.id);
        Assert.assertTrue((boolean)storedConf.id.equals(config4.id));
        Assert.assertTrue((boolean)storedConf.name.equals(config4.name));
        Assert.assertTrue((boolean)storedConf.moduleClass.equals(config4.moduleClass));
    }

    @Test
    public void testRemoveAndReadBack() throws Exception {
        ProcessConfig config1 = new ProcessConfig();
        config1.id = UUID.randomUUID().toString();
        config1.name = "Process1";
        config1.moduleClass = "org.sensorhub.process.ProcessModel";
        this.configDb.add(new ModuleConfig[]{config1});
        ServiceConfig config2 = new ServiceConfig();
        config2.id = UUID.randomUUID().toString();
        config2.name = "Service1";
        config2.moduleClass = "org.sensorhub.service.SosService";
        this.configDb.add(new ModuleConfig[]{config2});
        Assert.assertTrue((boolean)this.configDb.contains(config1.id));
        Assert.assertTrue((boolean)this.configDb.contains(config2.id));
        this.configDb.remove(new String[]{config1.id});
        this.configDb.close();
        this.configDb = new ModuleConfigJsonFile(this.configFile.getAbsolutePath());
        Assert.assertFalse((boolean)this.configDb.contains(config1.id));
    }

    private void displayFile() throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(this.configFile));
        while ((line = reader.readLine()) != null) {
            System.out.println(line);
        }
        reader.close();
    }

    @After
    public void cleanup() {
        if (this.configFile != null) {
            this.configFile.delete();
        }
    }
}

