/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.test.module;

import java.util.Arrays;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sensorhub.api.common.Event;
import org.sensorhub.api.common.IEventListener;
import org.sensorhub.api.common.SensorHubException;
import org.sensorhub.api.module.IModule;
import org.sensorhub.api.module.IModuleProvider;
import org.sensorhub.api.module.ModuleConfig;
import org.sensorhub.api.module.ModuleEvent;
import org.sensorhub.api.persistence.StorageConfig;
import org.sensorhub.api.processing.ProcessConfig;
import org.sensorhub.api.sensor.SensorConfig;
import org.sensorhub.api.service.IServiceModule;
import org.sensorhub.impl.SensorHub;
import org.sensorhub.impl.module.ModuleRegistry;
import org.sensorhub.test.module.AsyncModule;
import org.sensorhub.test.module.AsyncModuleConfig;
import org.sensorhub.test.module.DummyModule;
import org.sensorhub.test.module.MyConfig1;
import org.sensorhub.test.module.MyConfig2;

public class TestModuleRegistry {
    ModuleRegistry registry;

    @Before
    public void setup() {
        System.out.println("\n*****************************");
        this.registry = SensorHub.getInstance().getModuleRegistry();
    }

    private ModuleConfig createConfModule1() {
        MyConfig1 conf = new MyConfig1();
        conf.moduleClass = DummyModule.class.getCanonicalName();
        conf.id = "MOD1";
        conf.autoStart = true;
        conf.name = "Module1";
        conf.param1 = "text1";
        conf.param2 = 33;
        return conf;
    }

    private ModuleConfig createConfModule2() {
        MyConfig2 conf = new MyConfig2();
        conf.moduleClass = DummyModule.class.getCanonicalName();
        conf.id = "MOD2";
        conf.autoStart = true;
        conf.name = "Module2";
        conf.param1 = "text2";
        conf.param2 = 0.3256;
        return conf;
    }

    @Test
    public void testCloneConfig() throws Exception {
        ProcessConfig config1 = new ProcessConfig();
        config1.id = UUID.randomUUID().toString();
        config1.name = "Process1";
        config1.moduleClass = "org.sensorhub.process.ProcessModel";
        ProcessConfig clone1 = (ProcessConfig)config1.clone();
        Assert.assertTrue((boolean)clone1.id.equals(config1.id));
        Assert.assertTrue((boolean)clone1.name.equals(config1.name));
        Assert.assertTrue((boolean)clone1.moduleClass.equals(config1.moduleClass));
        SensorConfig config2 = new SensorConfig();
        config2.id = UUID.randomUUID().toString();
        config2.name = "sensor1";
        config2.moduleClass = "org.sensorhub.sensor.SensorDriver";
        config2.autoStart = true;
        config2.hiddenIO = new String[]{"input1", "input3"};
        SensorConfig clone2 = (SensorConfig)config2.clone();
        Assert.assertTrue((boolean)clone2.id.equals(config2.id));
        Assert.assertTrue((boolean)clone2.name.equals(config2.name));
        Assert.assertTrue((boolean)clone2.moduleClass.equals(config2.moduleClass));
        clone2.autoStart = config2.autoStart;
        Assert.assertTrue((boolean)clone2.autoStart);
        Assert.assertTrue((boolean)Arrays.deepEquals(clone2.hiddenIO, config2.hiddenIO));
        StorageConfig config4 = new StorageConfig();
        config4.id = UUID.randomUUID().toString();
        config4.name = "DB1";
        config4.moduleClass = "org.sensorhub.persistence.FeatureStorage";
        config4.autoStart = true;
        config4.storagePath = "path/to/db";
        StorageConfig clone4 = (StorageConfig)config4.clone();
        Assert.assertTrue((boolean)clone4.id.equals(config4.id));
        Assert.assertTrue((boolean)clone4.name.equals(config4.name));
        Assert.assertTrue((boolean)clone4.moduleClass.equals(config4.moduleClass));
        clone4.autoStart = config4.autoStart;
        Assert.assertTrue((boolean)clone4.autoStart);
    }

    @Test
    public void testGetInstalledModuleTypes() {
        System.out.println("\nAvailable Module Types");
        for (IModuleProvider moduleType : this.registry.getInstalledModuleTypes()) {
            System.out.println(moduleType.getModuleName() + ": " + moduleType.getModuleClass().getCanonicalName());
        }
        System.out.println("\nAvailable Service Types");
        for (IModuleProvider moduleType : this.registry.getInstalledModuleTypes(IServiceModule.class)) {
            System.out.println(moduleType.getModuleName() + ": " + moduleType.getModuleClass().getCanonicalName());
        }
        System.out.println();
    }

    @Test
    public void testLoadModules() throws Exception {
        ModuleConfig config = this.createConfModule1();
        IModule module = this.registry.loadModule(config);
        Assert.assertNotNull((String)"Module instance is null", (Object)module);
        Assert.assertNotNull((String)"Module configuration is null", (Object)module.getConfiguration());
        Assert.assertEquals((String)"Registry size is wrong", (long)1L, (long)this.registry.getLoadedModules().size());
        Assert.assertEquals((String)"Module name is wrong", (Object)this.registry.getModuleById(config.id).getName(), (Object)config.name);
        config = this.createConfModule2();
        module = this.registry.loadModule(config);
        Assert.assertNotNull((String)"Module instance is null", (Object)module);
        Assert.assertNotNull((String)"Module configuration is null", (Object)module.getConfiguration());
        Assert.assertEquals((String)"Registry size is wrong", (long)2L, (long)this.registry.getLoadedModules().size());
        Assert.assertEquals((String)"Module name is wrong", (Object)this.registry.getModuleById(config.id).getName(), (Object)config.name);
    }

    @Test
    public void testLoadModuleAsyncAutoStart() throws Exception {
        AsyncModuleConfig conf = new AsyncModuleConfig();
        conf.moduleClass = AsyncModule.class.getCanonicalName();
        conf.id = "MOD_ASYNC2";
        conf.autoStart = true;
        conf.name = "ModuleAsync2";
        conf.initDelay = 100L;
        conf.initExecTime = 150L;
        conf.startDelay = 200L;
        conf.startExecTime = 250L;
        long timeOut = 10000L;
        IModule module = this.registry.loadModuleAsync((ModuleConfig)conf, null);
        long t0 = System.currentTimeMillis();
        module.waitForState(ModuleEvent.ModuleState.INITIALIZED, timeOut);
        long t1 = System.currentTimeMillis();
        module.waitForState(ModuleEvent.ModuleState.STARTED, timeOut);
        long t2 = System.currentTimeMillis();
        long expectedDelay = conf.initDelay + conf.initExecTime;
        long delay = t1 - t0;
        Assert.assertTrue((String)"Init never executed", (delay >= expectedDelay ? 1 : 0) != 0);
        Assert.assertTrue((String)"Init timeout reached", (delay < timeOut ? 1 : 0) != 0);
        expectedDelay = conf.startDelay + conf.startExecTime;
        delay = t2 - t1;
        Assert.assertTrue((String)"Start never executed", (delay >= expectedDelay ? 1 : 0) != 0);
        Assert.assertTrue((String)"Start timeout reached", (delay < timeOut ? 1 : 0) != 0);
    }

    @Test
    public void testInitModuleAsync() throws Exception {
        final AsyncModuleConfig conf = new AsyncModuleConfig();
        conf.moduleClass = AsyncModule.class.getCanonicalName();
        conf.id = "MOD_ASYNC2";
        conf.autoStart = false;
        conf.name = "ModuleAsync2";
        conf.initDelay = 100L;
        conf.initExecTime = 200L;
        long timeOut = 10000L;
        IModule module = this.registry.loadModule((ModuleConfig)conf);
        long t0 = System.currentTimeMillis();
        this.registry.initModuleAsync(conf.id, false, new IEventListener(){

            public void handleEvent(Event<?> e) {
                if (((ModuleEvent)e).getNewState() == ModuleEvent.ModuleState.INITIALIZED) {
                    conf.initEventReceived = true;
                }
            }
        });
        module.waitForState(ModuleEvent.ModuleState.INITIALIZED, timeOut);
        long t1 = System.currentTimeMillis();
        long expectedDelay = conf.initDelay + conf.initExecTime;
        long delay = t1 - t0;
        Assert.assertTrue((String)"Init never executed", (delay >= expectedDelay ? 1 : 0) != 0);
        Assert.assertTrue((String)"Init timeout reached", (delay < timeOut ? 1 : 0) != 0);
    }

    @Test
    public void testInitModuleAsyncTimeout() throws Exception {
        AsyncModuleConfig conf = new AsyncModuleConfig();
        conf.moduleClass = AsyncModule.class.getCanonicalName();
        conf.id = "MOD_ASYNC2";
        conf.autoStart = false;
        conf.name = "ModuleAsync2";
        conf.initDelay = 100L;
        conf.initExecTime = 200L;
        long timeOut = 100L;
        IModule module = this.registry.loadModule((ModuleConfig)conf);
        this.registry.initModuleAsync(conf.id, false, null);
        boolean noTimeOut = module.waitForState(ModuleEvent.ModuleState.INITIALIZED, timeOut);
        Assert.assertFalse((String)"Init timeout flag not set", (boolean)noTimeOut);
    }

    @Test
    public void testStartModuleAsync() throws Exception {
        final AsyncModuleConfig conf = new AsyncModuleConfig();
        conf.moduleClass = AsyncModule.class.getCanonicalName();
        conf.id = "MOD_ASYNC2";
        conf.autoStart = false;
        conf.name = "ModuleAsync2";
        conf.initDelay = 100L;
        conf.initExecTime = 150L;
        conf.startDelay = 50L;
        conf.startExecTime = 100L;
        long timeOut = 10000L;
        IModule module = this.registry.loadModule((ModuleConfig)conf);
        long t0 = System.currentTimeMillis();
        this.registry.startModuleAsync(conf.id, new IEventListener(){

            public void handleEvent(Event<?> e) {
                if (((ModuleEvent)e).getNewState() == ModuleEvent.ModuleState.INITIALIZED) {
                    conf.initEventReceived = true;
                } else if (((ModuleEvent)e).getNewState() == ModuleEvent.ModuleState.STARTED) {
                    conf.startEventReceived = true;
                }
            }
        });
        module.waitForState(ModuleEvent.ModuleState.INITIALIZED, timeOut);
        long t1 = System.currentTimeMillis();
        module.waitForState(ModuleEvent.ModuleState.STARTED, timeOut);
        long t2 = System.currentTimeMillis();
        long expectedDelay = conf.initDelay + conf.initExecTime;
        long delay = t1 - t0;
        Assert.assertTrue((String)"Init never executed", (delay >= expectedDelay ? 1 : 0) != 0);
        Assert.assertTrue((String)"Init timeout reached", (delay < timeOut ? 1 : 0) != 0);
        expectedDelay = conf.startDelay + conf.startExecTime;
        delay = t2 - t1;
        Assert.assertTrue((String)"Start never executed", (delay >= expectedDelay ? 1 : 0) != 0);
        Assert.assertTrue((String)"Start timeout reached", (delay < timeOut ? 1 : 0) != 0);
    }

    @Test
    public void testStartModuleAsyncWithDependency() throws Exception {
        long timeOut = 2000L;
        AsyncModuleConfig conf1 = new AsyncModuleConfig();
        conf1.moduleClass = AsyncModule.class.getCanonicalName();
        conf1.id = "MOD_ASYNC1";
        conf1.autoStart = false;
        conf1.name = "ModuleAsync1";
        conf1.initDelay = 100L;
        conf1.initExecTime = 150L;
        conf1.startDelay = 50L;
        conf1.startExecTime = 100L;
        IModule module1 = this.registry.loadModule((ModuleConfig)conf1);
        final AsyncModuleConfig conf2 = new AsyncModuleConfig();
        conf2.moduleClass = AsyncModule.class.getCanonicalName();
        conf2.id = "MOD_ASYNC2";
        conf2.autoStart = false;
        conf2.name = "ModuleAsync2";
        conf2.initDelay = 10L;
        conf2.initExecTime = 15L;
        conf2.startDelay = 50L;
        conf2.startExecTime = 10L;
        conf2.moduleIDNeededForStart = conf1.id;
        conf2.moduleStateNeededForStart = ModuleEvent.ModuleState.STARTED;
        IModule module2 = this.registry.loadModule((ModuleConfig)conf2);
        long t0 = System.currentTimeMillis();
        this.registry.startModuleAsync(conf2.id, new IEventListener(){

            public void handleEvent(Event<?> e) {
                if (((ModuleEvent)e).getNewState() == ModuleEvent.ModuleState.INITIALIZED) {
                    conf2.initEventReceived = true;
                } else if (((ModuleEvent)e).getNewState() == ModuleEvent.ModuleState.STARTED) {
                    conf2.startEventReceived = true;
                }
            }
        });
        module2.waitForState(ModuleEvent.ModuleState.INITIALIZED, timeOut);
        long t1 = System.currentTimeMillis();
        module2.waitForState(ModuleEvent.ModuleState.STARTED, timeOut);
        long t2 = System.currentTimeMillis();
        long expectedDelay = conf2.initDelay + conf2.initExecTime;
        long delay = t1 - t0;
        Assert.assertTrue((String)"Init never executed", (delay >= expectedDelay ? 1 : 0) != 0);
        Assert.assertTrue((String)"Init timeout reached", (delay < timeOut ? 1 : 0) != 0);
        delay = t2 - t1;
        Assert.assertTrue((String)"Start timeout should have occured", (delay >= timeOut ? 1 : 0) != 0);
        t0 = System.currentTimeMillis();
        this.registry.startModuleAsync(conf1.id, null);
        module1.waitForState(ModuleEvent.ModuleState.STARTED, timeOut);
        module2.waitForState(ModuleEvent.ModuleState.STARTED, timeOut);
        t1 = System.currentTimeMillis();
        expectedDelay = conf1.startDelay + conf1.startExecTime + conf2.startExecTime;
        delay = t1 - t0;
        Assert.assertTrue((String)"Start never executed", (delay >= expectedDelay ? 1 : 0) != 0);
        Assert.assertTrue((String)"Start timeout reached", (delay < timeOut ? 1 : 0) != 0);
    }

    @Test
    public void testRestartModuleAsync() throws Exception {
        final AsyncModuleConfig conf = new AsyncModuleConfig();
        conf.moduleClass = AsyncModule.class.getCanonicalName();
        conf.id = "MOD_ASYNC2";
        conf.autoStart = false;
        conf.name = "ModuleAsync2";
        conf.initDelay = 500L;
        conf.initExecTime = 500L;
        long timeOut = 10000L;
        IModule module = this.registry.loadModule((ModuleConfig)conf);
        this.registry.startModuleAsync(conf.id, null);
        module.waitForState(ModuleEvent.ModuleState.STARTED, timeOut);
        Assert.assertEquals((String)"Module was not started", (Object)ModuleEvent.ModuleState.STARTED, (Object)module.getCurrentState());
        long t0 = System.currentTimeMillis();
        this.registry.stopModuleAsync(conf.id, new IEventListener(){

            public void handleEvent(Event<?> e) {
                if (((ModuleEvent)e).getNewState() == ModuleEvent.ModuleState.STOPPED) {
                    conf.stopEventReceived = true;
                } else if (((ModuleEvent)e).getNewState() == ModuleEvent.ModuleState.STARTED) {
                    conf.startEventReceived = true;
                }
            }
        });
        module.waitForState(ModuleEvent.ModuleState.STOPPING, timeOut);
        this.registry.startModuleAsync(conf.id, null);
        module.waitForState(ModuleEvent.ModuleState.STARTED, timeOut);
        long t1 = System.currentTimeMillis();
        long expectedDelay = conf.startDelay + conf.startExecTime;
        long delay = t1 - t0;
        Assert.assertTrue((String)"Start never executed", (delay >= expectedDelay ? 1 : 0) != 0);
        Assert.assertTrue((String)"Start timeout reached", (delay < timeOut ? 1 : 0) != 0);
    }

    @After
    public void cleanup() {
        try {
            this.registry.shutdown(false, false);
            SensorHub.clearInstance();
        }
        catch (SensorHubException sensorHubException) {
            // empty catch block
        }
    }
}

