/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.test.osgi;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public class TestOsgi {
    private static String CACHE_FOLDER = "osgi-cache";

    protected Framework getFramework() {
        Iterator<FrameworkFactory> it = ServiceLoader.load(FrameworkFactory.class).iterator();
        Assert.assertTrue((String)"No OSGI implementation found in classpath", (boolean)it.hasNext());
        HashMap<String, String> osgiConfig = new HashMap<String, String>();
        osgiConfig.put("org.osgi.framework.storage", CACHE_FOLDER);
        osgiConfig.put("org.osgi.framework.storage.clean", "onFirstInit");
        Framework fw = it.next().newFramework(osgiConfig);
        return fw;
    }

    protected Bundle installBundle(Framework fw, String bundleURL, String bundleName) throws Exception {
        int numBundles = fw.getBundleContext().getBundles().length;
        Bundle newBundle = fw.getBundleContext().installBundle(bundleURL);
        Assert.assertTrue((String)"bundle should not be null", (newBundle != null ? 1 : 0) != 0);
        System.out.println("Bundle name is " + newBundle.getSymbolicName());
        Assert.assertEquals((String)"Wrong number of loaded bundles", (long)(numBundles + 1), (long)fw.getBundleContext().getBundles().length);
        Assert.assertEquals((String)"Unexpected bundle name", (Object)bundleName, (Object)newBundle.getSymbolicName());
        Assert.assertEquals((String)"Bundle should be in INSTALLED state", (long)2L, (long)newBundle.getState());
        return newBundle;
    }

    @Test
    public void test1StartStopFramework() throws Exception {
        Framework fw = this.getFramework();
        fw.start();
        Thread.sleep(500L);
        fw.stop();
        fw.waitForStop(0L);
    }

    @Test
    public void test2InstallBundle() throws Exception {
        Framework fw = this.getFramework();
        fw.start();
        Bundle newBundle = this.installBundle(fw, this.getClass().getResource("/test-nodep.jar").toString(), "org.sensorhub.test");
        newBundle.start();
        Assert.assertEquals((String)"Bundle should be in ACTIVE state", (long)32L, (long)newBundle.getState());
        fw.stop();
        fw.waitForStop(0L);
    }

    @Test
    public void test3BundleDependencies() throws Exception {
        Framework fw = this.getFramework();
        fw.start();
        Assert.assertEquals((String)"Wrong number of loaded bundles", (long)1L, (long)fw.getBundleContext().getBundles().length);
        this.installBundle(fw, this.getClass().getResource("/test-nodep.jar").toString(), "org.sensorhub.test");
        Bundle bundle2 = this.installBundle(fw, this.getClass().getResource("/test-withdep.jar").toString(), "org.sensorhub.test2");
        bundle2.start();
        Assert.assertEquals((String)("Bundle " + bundle2.getSymbolicName() + " should be in ACTIVE state"), (long)32L, (long)bundle2.getState());
        fw.stop();
        fw.waitForStop(0L);
    }

    @AfterClass
    public static void cleanup() {
        try {
            FileUtils.deleteDirectory((File)new File(CACHE_FOLDER));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

