/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.test.persistence;

import org.sensorhub.api.persistence.IMultiSourceStorage;
import org.sensorhub.api.persistence.IObsStorageModule;
import org.sensorhub.test.persistence.AbstractTestObsStorage;

public abstract class AbstractTestMultiObsStorage<StorageType extends IObsStorageModule<?>>
extends AbstractTestObsStorage<StorageType> {
    static int NUM_PRODUCERS = 10;

    protected void addProducersToStorage() throws Exception {
        for (int i = 1; i <= NUM_PRODUCERS; ++i) {
            String producerID = SENSOR_UID_PREFIX + i;
            ((IMultiSourceStorage)this.storage).addDataStore(producerID);
        }
    }

    @Override
    public void testCreateDataStores() throws Exception {
        this.addProducersToStorage();
        super.testCreateDataStores();
    }

    @Override
    public void testStoreAndRetrieveFoisByID() throws Exception {
        this.addProducersToStorage();
        super.testStoreAndRetrieveFoisByID();
    }

    @Override
    public void testStoreAndRetrieveFoisWithWrongIDs() throws Exception {
        this.addProducersToStorage();
        super.testStoreAndRetrieveFoisWithWrongIDs();
    }

    @Override
    public void testStoreAndRetrieveFoisByRoi() throws Exception {
        this.addProducersToStorage();
        super.testStoreAndRetrieveFoisByRoi();
    }

    @Override
    public void testStoreOneFoiAndGetRecordsByFoiID() throws Exception {
        this.addProducersToStorage();
        super.testStoreOneFoiAndGetRecordsByFoiID();
    }

    @Override
    public void testGetRecordsForOneFoiID() throws Exception {
        this.addProducersToStorage();
        super.testGetRecordsForOneFoiID();
    }

    @Override
    public void testGetRecordsForMultipleFoiIDs() throws Exception {
        this.addProducersToStorage();
        super.testGetRecordsForMultipleFoiIDs();
    }

    @Override
    public void testGetRecordsForOneFoiIDAndTime() throws Exception {
        this.addProducersToStorage();
        super.testGetRecordsForOneFoiIDAndTime();
    }

    @Override
    public void testGetRecordsForMultipleFoiIDsAndTime() throws Exception {
        this.addProducersToStorage();
        super.testGetRecordsForMultipleFoiIDsAndTime();
    }

    @Override
    public void testGetRecordsByRoi() throws Exception {
        this.addProducersToStorage();
        super.testGetRecordsByRoi();
    }

    @Override
    public void testStoreAndGetLatestSensorML() throws Exception {
        this.addProducersToStorage();
        super.testStoreAndGetLatestSensorML();
    }

    @Override
    public void testStoreAndGetSensorMLByTime() throws Exception {
        this.addProducersToStorage();
        super.testStoreAndGetSensorMLByTime();
    }

    @Override
    public void testStoreAndGetRecordsByKey() throws Exception {
        this.addProducersToStorage();
        super.testStoreAndGetRecordsByKey();
    }

    @Override
    public void testStoreAndGetMultipleRecordsByKey() throws Exception {
        this.addProducersToStorage();
        super.testStoreAndGetMultipleRecordsByKey();
    }

    @Override
    public void testStoreAndGetMultipleRecordsByFilter() throws Exception {
        this.addProducersToStorage();
        super.testStoreAndGetMultipleRecordsByFilter();
    }

    @Override
    public void testStoreAndGetTimeRange() throws Exception {
        this.addProducersToStorage();
        super.testStoreAndGetTimeRange();
    }

    @Override
    public void testStoreIncompatibleRecord() throws Exception {
        this.addProducersToStorage();
        super.testStoreIncompatibleRecord();
    }

    @Override
    public void testConcurrentWriteRecords() throws Throwable {
        this.addProducersToStorage();
        super.testConcurrentWriteRecords();
    }

    @Override
    public void testConcurrentWriteThenReadRecords() throws Throwable {
        this.addProducersToStorage();
        super.testConcurrentWriteThenReadRecords();
    }

    @Override
    public void testConcurrentReadWriteMetadataAndRecords() throws Throwable {
        this.addProducersToStorage();
        super.testConcurrentReadWriteMetadataAndRecords();
    }

    @Override
    public void testConcurrentReadWriteRecords() throws Throwable {
        this.addProducersToStorage();
        super.testConcurrentReadWriteRecords();
    }

    static {
        NUM_FOIS = 3;
    }
}

