/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.test.persistence;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import net.opengis.gml.v32.AbstractFeature;
import net.opengis.gml.v32.AbstractGeometry;
import net.opengis.gml.v32.Point;
import net.opengis.gml.v32.impl.GMLFactory;
import net.opengis.swe.v20.DataBlock;
import net.opengis.swe.v20.DataComponent;
import org.junit.Assert;
import org.junit.Test;
import org.sensorhub.api.persistence.DataKey;
import org.sensorhub.api.persistence.FoiFilter;
import org.sensorhub.api.persistence.IDataFilter;
import org.sensorhub.api.persistence.IDataRecord;
import org.sensorhub.api.persistence.IFoiFilter;
import org.sensorhub.api.persistence.IObsFilter;
import org.sensorhub.api.persistence.IObsStorageModule;
import org.sensorhub.api.persistence.ObsFilter;
import org.sensorhub.api.persistence.ObsKey;
import org.sensorhub.test.TestUtils;
import org.sensorhub.test.persistence.AbstractTestBasicStorage;
import org.vast.ogc.gml.GenericFeatureImpl;
import org.vast.util.Bbox;

public abstract class AbstractTestObsStorage<StorageType extends IObsStorageModule<?>>
extends AbstractTestBasicStorage<StorageType> {
    static String FOI_UID_PREFIX = "urn:domain:features:foi";
    static int NUM_FOIS = 100;
    GMLFactory gmlFac = new GMLFactory(true);
    Map<String, AbstractFeature> allFeatures;
    static String[] FOI_SET1_IDS = new String[]{FOI_UID_PREFIX + "1", FOI_UID_PREFIX + "2", FOI_UID_PREFIX + "3", FOI_UID_PREFIX + "4", FOI_UID_PREFIX + "15"};
    static int[] FOI_SET1_STARTS = new int[]{0, 20, 25, 40, 60};
    String[] FOI_IDS = FOI_SET1_IDS;
    int[] FOI_STARTS = FOI_SET1_STARTS;

    protected void addFoisToStorage() throws Exception {
        this.allFeatures = new LinkedHashMap<String, AbstractFeature>(NUM_FOIS);
        for (int foiNum = 1; foiNum <= NUM_FOIS; ++foiNum) {
            QName fType = new QName("http://myNsUri", "MyFeature");
            GenericFeatureImpl foi = new GenericFeatureImpl(fType);
            foi.setId("F" + foiNum);
            foi.setUniqueIdentifier(FOI_UID_PREFIX + foiNum);
            foi.setName("FOI" + foiNum);
            foi.setDescription("This is feature of interest #" + foiNum);
            Point p = this.gmlFac.newPoint();
            p.setPos(new double[]{foiNum, foiNum, 0.0});
            foi.setLocation((AbstractGeometry)p);
            this.allFeatures.put(foi.getUniqueIdentifier(), (AbstractFeature)foi);
            ((IObsStorageModule)this.storage).storeFoi(this.producerID, (AbstractFeature)foi);
        }
        ((IObsStorageModule)this.storage).commit();
        this.forceReadBackFromStorage();
    }

    @Test
    public void testStoreAndRetrieveFoisByID() throws Exception {
        this.addFoisToStorage();
        this.testFilterFoiByID(1, 2, 3, 22, 50, 78);
        this.testFilterFoiByID(1);
        this.testFilterFoiByID(56);
        int[] ids = new int[NUM_FOIS];
        for (int i = 1; i <= NUM_FOIS; ++i) {
            ids[i - 1] = i;
        }
        this.testFilterFoiByID(ids);
    }

    @Test
    public void testStoreAndRetrieveFoisWithWrongIDs() throws Exception {
        this.addFoisToStorage();
        this.testFilterFoiByID(102);
        this.testFilterFoiByID(102, 56, 516);
        this.testFilterFoiByID(102, 103, 104, 56, 516, 5);
    }

    protected void testFilterFoiByID(int ... foiNums) {
        final ArrayList<String> idList = new ArrayList<String>(foiNums.length);
        for (int foiNum : foiNums) {
            idList.add(FOI_UID_PREFIX + foiNum);
        }
        FoiFilter filter = new FoiFilter(){

            public Collection<String> getFeatureIDs() {
                return idList;
            }

            public Collection<String> getProducerIDs() {
                return AbstractTestObsStorage.this.producerFilterList;
            }
        };
        int numWrongIDs = 0;
        for (int foiNum : foiNums) {
            numWrongIDs += foiNum > NUM_FOIS ? 1 : 0;
        }
        Iterator it = ((IObsStorageModule)this.storage).getFois((IFoiFilter)filter);
        int i = 0;
        int foiCount = 0;
        while (it.hasNext()) {
            int nextNum;
            if ((nextNum = foiNums[i++]) > NUM_FOIS) continue;
            Assert.assertEquals((Object)(FOI_UID_PREFIX + nextNum), (Object)((AbstractFeature)it.next()).getUniqueIdentifier());
            ++foiCount;
        }
        Assert.assertEquals((long)(foiNums.length - numWrongIDs), (long)foiCount);
        Iterator it2 = ((IObsStorageModule)this.storage).getFoiIDs((IFoiFilter)filter);
        i = 0;
        foiCount = 0;
        while (it2.hasNext()) {
            int nextNum;
            if ((nextNum = foiNums[i++]) > NUM_FOIS) continue;
            Assert.assertEquals((Object)(FOI_UID_PREFIX + nextNum), it2.next());
            ++foiCount;
        }
        Assert.assertEquals((long)(foiNums.length - numWrongIDs), (long)foiCount);
    }

    @Test
    public void testStoreAndRetrieveFoisByRoi() throws Exception {
        this.addFoisToStorage();
        for (int i = 1; i <= NUM_FOIS; ++i) {
            this.testFilterFoiByRoi(new Bbox((double)i - 0.5, (double)i - 0.5, (double)i + 0.5, (double)i + 0.5), i);
        }
    }

    protected void testFilterFoiByRoi(Bbox bbox, int ... foiNums) {
        final Polygon poly = (Polygon)new GeometryFactory().toGeometry(bbox.toJtsEnvelope());
        FoiFilter filter = new FoiFilter(){

            public Polygon getRoi() {
                return poly;
            }

            public Collection<String> getProducerIDs() {
                return AbstractTestObsStorage.this.producerFilterList;
            }
        };
        Iterator it = ((IObsStorageModule)this.storage).getFois((IFoiFilter)filter);
        int i = 0;
        while (it.hasNext()) {
            Assert.assertEquals((Object)(FOI_UID_PREFIX + foiNums[i++]), (Object)((AbstractFeature)it.next()).getUniqueIdentifier());
        }
        Assert.assertEquals((long)foiNums.length, (long)i);
        Iterator it2 = ((IObsStorageModule)this.storage).getFoiIDs((IFoiFilter)filter);
        i = 0;
        while (it2.hasNext()) {
            Assert.assertEquals((Object)(FOI_UID_PREFIX + foiNums[i++]), it2.next());
        }
        Assert.assertEquals((long)foiNums.length, (long)i);
    }

    protected List<DataBlock> addObservationsWithFoiToStorage(DataComponent recordDef) throws Exception {
        double timeStep = 0.1;
        int numRecords = 100;
        ArrayList<DataBlock> dataList = new ArrayList<DataBlock>(100);
        for (int i = 0; i < 100; ++i) {
            DataBlock data = recordDef.createDataBlock();
            data.setDoubleValue(0, (double)i * 0.1);
            data.setIntValue(1, 3 * i);
            data.setStringValue(2, "test" + i);
            dataList.add(data);
            String foiID = null;
            for (int f = 0; f < this.FOI_IDS.length; ++f) {
                if (i < this.FOI_STARTS[f]) continue;
                foiID = this.FOI_IDS[f];
            }
            ObsKey key = new ObsKey(recordDef.getName(), this.producerID, foiID, (double)i * 0.1);
            ((IObsStorageModule)this.storage).storeRecord((DataKey)key, data);
        }
        ((IObsStorageModule)this.storage).commit();
        this.forceReadBackFromStorage();
        return dataList;
    }

    protected IObsFilter buildFilterByFoiID(DataComponent recordDef, List<DataBlock> dataList, int[] foiIndexes) {
        final HashSet<String> foiSet = new HashSet<String>();
        for (int index : foiIndexes) {
            foiSet.add(this.FOI_IDS[index]);
        }
        ObsFilter filter = new ObsFilter(recordDef.getName()){

            public Set<String> getFoiIDs() {
                return foiSet;
            }

            public Collection<String> getProducerIDs() {
                return AbstractTestObsStorage.this.producerFilterList;
            }
        };
        int i = 0;
        Iterator<DataBlock> it = dataList.iterator();
        while (it.hasNext()) {
            it.next();
            boolean foundFoi = false;
            for (int index : foiIndexes) {
                int endIndex;
                int startIndex = this.FOI_STARTS[index];
                int n = endIndex = index == this.FOI_IDS.length - 1 ? 100 : this.FOI_STARTS[index + 1];
                if (i < startIndex || i > endIndex - 1) continue;
                foundFoi = true;
                break;
            }
            if (!foundFoi) {
                it.remove();
            }
            ++i;
        }
        return filter;
    }

    protected IObsFilter buildFilterByRoi(DataComponent recordDef, List<DataBlock> dataList, final Polygon roi) {
        ArrayList<Integer> foiIndexList = new ArrayList<Integer>();
        int fIndex = 0;
        for (String foiID : this.FOI_IDS) {
            AbstractFeature f = this.allFeatures.get(foiID);
            if (f != null && roi.intersects((Geometry)f.getLocation())) {
                foiIndexList.add(fIndex);
            }
            ++fIndex;
        }
        int i = 0;
        int[] foiIndexes = new int[foiIndexList.size()];
        Iterator i$ = foiIndexList.iterator();
        while (i$.hasNext()) {
            int index = (Integer)i$.next();
            foiIndexes[i++] = index;
        }
        this.buildFilterByFoiID(recordDef, dataList, foiIndexes);
        ObsFilter filter = new ObsFilter(recordDef.getName()){

            public Polygon getRoi() {
                return roi;
            }

            public Collection<String> getProducerIDs() {
                return AbstractTestObsStorage.this.producerFilterList;
            }
        };
        return filter;
    }

    protected IObsFilter buildFilterByFoiIDAndTime(DataComponent recordDef, List<DataBlock> dataList, int[] foiIndexes, final double[] timeRange) {
        final HashSet<String> foiSet = new HashSet<String>();
        for (int index : foiIndexes) {
            foiSet.add(this.FOI_IDS[index]);
        }
        ObsFilter filter = new ObsFilter(recordDef.getName()){

            public double[] getTimeStampRange() {
                return timeRange;
            }

            public Set<String> getFoiIDs() {
                return foiSet;
            }

            public Collection<String> getProducerIDs() {
                return AbstractTestObsStorage.this.producerFilterList;
            }
        };
        int i = 0;
        Iterator<DataBlock> it = dataList.iterator();
        while (it.hasNext()) {
            DataBlock data = it.next();
            double timeStamp = data.getDoubleValue(0);
            boolean foundFoi = false;
            for (int index : foiIndexes) {
                int endIndex;
                int startIndex = this.FOI_STARTS[index];
                int n = endIndex = index == this.FOI_IDS.length - 1 ? 100 : this.FOI_STARTS[index + 1];
                if (i < startIndex || i > endIndex - 1) continue;
                foundFoi = true;
                break;
            }
            if (!foundFoi || timeStamp < timeRange[0] || timeStamp > timeRange[1]) {
                it.remove();
            }
            ++i;
        }
        return filter;
    }

    protected void checkFilteredResults(IObsFilter filter, List<DataBlock> dataList) throws Exception {
        int i = 0;
        Iterator it1 = ((IObsStorageModule)this.storage).getDataBlockIterator((IDataFilter)filter);
        while (it1.hasNext()) {
            DataBlock blk = (DataBlock)it1.next();
            if (dataList.size() > i) {
                TestUtils.assertEquals(dataList.get(i), blk);
            }
            ++i;
        }
        Assert.assertEquals((String)"Wrong number of records", (long)dataList.size(), (long)i);
        i = 0;
        Iterator it2 = ((IObsStorageModule)this.storage).getRecordIterator((IDataFilter)filter);
        while (it2.hasNext()) {
            IDataRecord dbRec = (IDataRecord)it2.next();
            if (dataList.size() > i) {
                TestUtils.assertEquals(dataList.get(i), dbRec.getData());
                if (filter.getFoiIDs() != null) {
                    Assert.assertTrue((boolean)filter.getFoiIDs().contains(((ObsKey)dbRec.getKey()).foiID));
                }
            }
            ++i;
        }
        Assert.assertEquals((String)"Wrong number of records", (long)dataList.size(), (long)i);
    }

    @Test
    public void testStoreOneFoiAndGetRecordsByFoiID() throws Exception {
        this.FOI_IDS = new String[]{"urn:domain:features:myfoi"};
        this.FOI_STARTS = new int[1];
        DataComponent recordDef = this.createDs2();
        List<DataBlock> dataList = this.addObservationsWithFoiToStorage(recordDef);
        int[] foiIndex = new int[]{0};
        IObsFilter filter = this.buildFilterByFoiID(recordDef, dataList, foiIndex);
        this.checkFilteredResults(filter, dataList);
    }

    @Test
    public void testGetRecordsForOneFoiID() throws Exception {
        DataComponent recordDef = this.createDs2();
        List<DataBlock> dataList = this.addObservationsWithFoiToStorage(recordDef);
        ArrayList<DataBlock> testList = new ArrayList<DataBlock>(dataList.size());
        int foiIndex = 0;
        while (foiIndex < this.FOI_IDS.length) {
            testList.clear();
            testList.addAll(dataList);
            IObsFilter filter = this.buildFilterByFoiID(recordDef, testList, new int[]{foiIndex++});
            this.checkFilteredResults(filter, testList);
        }
    }

    @Test
    public void testGetRecordsForMultipleFoiIDs() throws Exception {
        DataComponent recordDef = this.createDs2();
        List<DataBlock> dataList = this.addObservationsWithFoiToStorage(recordDef);
        ArrayList<DataBlock> testList = new ArrayList<DataBlock>(dataList.size());
        testList.clear();
        testList.addAll(dataList);
        IObsFilter filter = this.buildFilterByFoiID(recordDef, testList, new int[]{0, 1});
        this.checkFilteredResults(filter, testList);
        testList.clear();
        testList.addAll(dataList);
        filter = this.buildFilterByFoiID(recordDef, testList, new int[]{0, 2});
        this.checkFilteredResults(filter, testList);
        testList.clear();
        testList.addAll(dataList);
        filter = this.buildFilterByFoiID(recordDef, testList, new int[]{2, 1});
        this.checkFilteredResults(filter, testList);
        testList.clear();
        testList.addAll(dataList);
        filter = this.buildFilterByFoiID(recordDef, testList, new int[]{1, 0, 2});
        this.checkFilteredResults(filter, testList);
    }

    @Test
    public void testGetRecordsForOneFoiIDAndTime() throws Exception {
        DataComponent recordDef = this.createDs2();
        List<DataBlock> dataList = this.addObservationsWithFoiToStorage(recordDef);
        ArrayList<DataBlock> testList = new ArrayList<DataBlock>(dataList.size());
        double[] timeRange1 = new double[]{1.0, 8.4};
        int foiIndex = 0;
        while (foiIndex < this.FOI_IDS.length) {
            testList.clear();
            testList.addAll(dataList);
            IObsFilter filter = this.buildFilterByFoiIDAndTime(recordDef, testList, new int[]{foiIndex++}, timeRange1);
            this.checkFilteredResults(filter, testList);
        }
    }

    @Test
    public void testGetRecordsForMultipleFoiIDsAndTime() throws Exception {
        DataComponent recordDef = this.createDs2();
        List<DataBlock> dataList = this.addObservationsWithFoiToStorage(recordDef);
        ArrayList<DataBlock> testList = new ArrayList<DataBlock>(dataList.size());
        double[] timeRange = new double[]{1.0, 8.4};
        testList.clear();
        testList.addAll(dataList);
        IObsFilter filter = this.buildFilterByFoiIDAndTime(recordDef, testList, new int[]{0, 1}, timeRange);
        this.checkFilteredResults(filter, testList);
        timeRange = new double[]{2.5, 8.4};
        testList.clear();
        testList.addAll(dataList);
        filter = this.buildFilterByFoiIDAndTime(recordDef, testList, new int[]{2, 1}, timeRange);
        this.checkFilteredResults(filter, testList);
    }

    @Test
    public void testGetRecordsByRoi() throws Exception {
        this.addFoisToStorage();
        DataComponent recordDef = this.createDs2();
        List<DataBlock> dataList = this.addObservationsWithFoiToStorage(recordDef);
        ArrayList<DataBlock> testList = new ArrayList<DataBlock>(dataList.size());
        testList.clear();
        testList.addAll(dataList);
        Polygon roi = new GeometryFactory().createPolygon(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(0.0, 0.1), new Coordinate(0.1, 0.1), new Coordinate(0.1, 0.0), new Coordinate(0.0, 0.0)});
        IObsFilter filter = this.buildFilterByRoi(recordDef, testList, roi);
        this.checkFilteredResults(filter, testList);
        testList.clear();
        testList.addAll(dataList);
        roi = new GeometryFactory().createPolygon(new Coordinate[]{new Coordinate(0.5, 0.5), new Coordinate(0.5, 1.5), new Coordinate(1.5, 1.5), new Coordinate(1.5, 0.5), new Coordinate(0.5, 0.5)});
        filter = this.buildFilterByRoi(recordDef, testList, roi);
        this.checkFilteredResults(filter, testList);
        testList.clear();
        testList.addAll(dataList);
        roi = new GeometryFactory().createPolygon(new Coordinate[]{new Coordinate(0.5, 0.5), new Coordinate(0.5, 3.5), new Coordinate(3.5, 3.5), new Coordinate(3.5, 2.5), new Coordinate(1.5, 2.5), new Coordinate(1.5, 0.5), new Coordinate(0.5, 0.5)});
        filter = this.buildFilterByRoi(recordDef, testList, roi);
        this.checkFilteredResults(filter, testList);
        testList.clear();
        testList.addAll(dataList);
        roi = new GeometryFactory().createPolygon(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(0.0, 4.0), new Coordinate(4.0, 4.0), new Coordinate(4.0, 0.0), new Coordinate(0.0, 0.0)});
        filter = this.buildFilterByRoi(recordDef, testList, roi);
        this.checkFilteredResults(filter, testList);
    }
}

