/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.test.persistence;

import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sensorhub.api.common.SensorHubException;
import org.sensorhub.api.module.ModuleConfig;
import org.sensorhub.api.persistence.StorageConfig;
import org.sensorhub.api.sensor.ISensorDataInterface;
import org.sensorhub.api.sensor.ISensorModule;
import org.sensorhub.api.sensor.SensorConfig;
import org.sensorhub.impl.SensorHub;
import org.sensorhub.impl.module.ModuleRegistry;
import org.sensorhub.impl.persistence.GenericStreamStorage;
import org.sensorhub.impl.persistence.InMemoryBasicStorage;
import org.sensorhub.impl.persistence.StreamStorageConfig;
import org.sensorhub.test.sensor.FakeSensor;
import org.sensorhub.test.sensor.FakeSensorData;

public class TestGenericStreamStorage {
    private static final String OUTPUT_NAME = "out1";
    File configFile;
    FakeSensorData fakeSensorData;
    GenericStreamStorage storage;
    ModuleRegistry registry;

    @Before
    public void setup() throws Exception {
        this.registry = SensorHub.getInstance().getModuleRegistry();
        SensorConfig sensorCfg = new SensorConfig();
        sensorCfg.autoStart = false;
        sensorCfg.moduleClass = FakeSensor.class.getCanonicalName();
        sensorCfg.name = "Sensor1";
        ISensorModule sensor = (ISensorModule)this.registry.loadModule((ModuleConfig)sensorCfg);
        this.fakeSensorData = new FakeSensorData((FakeSensor)sensor, OUTPUT_NAME, 10, 0.1, 10);
        ((FakeSensor)sensor).setDataInterfaces(new ISensorDataInterface[]{this.fakeSensorData});
        this.registry.startModule(sensor.getLocalID());
        StreamStorageConfig genericStorageConfig = new StreamStorageConfig();
        genericStorageConfig.moduleClass = GenericStreamStorage.class.getCanonicalName();
        genericStorageConfig.name = "SensorStorageTest";
        genericStorageConfig.autoStart = true;
        genericStorageConfig.dataSourceID = sensor.getLocalID();
        StorageConfig storageConfig = new StorageConfig();
        storageConfig.moduleClass = InMemoryBasicStorage.class.getCanonicalName();
        genericStorageConfig.storageConfig = storageConfig;
        this.storage = (GenericStreamStorage)this.registry.loadModule((ModuleConfig)genericStorageConfig);
    }

    @Test
    public void testAddRecordToStorage() throws Exception {
        while (this.fakeSensorData.isEnabled()) {
            Thread.sleep((long)(this.fakeSensorData.getAverageSamplingPeriod() * 500.0));
        }
        Thread.sleep(100L);
        Assert.assertEquals((long)this.fakeSensorData.getMaxSampleCount(), (long)this.storage.getNumRecords(OUTPUT_NAME));
    }

    @After
    public void cleanup() {
        try {
            this.registry.shutdown(false, false);
            SensorHub.clearInstance();
        }
        catch (SensorHubException sensorHubException) {
            // empty catch block
        }
    }
}

