/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.test.processing;

import net.opengis.swe.v20.DataBlock;
import net.opengis.swe.v20.DataComponent;
import net.opengis.swe.v20.DataEncoding;
import org.sensorhub.api.common.Event;
import org.sensorhub.api.common.IEventHandler;
import org.sensorhub.api.common.IEventListener;
import org.sensorhub.api.data.DataEvent;
import org.sensorhub.api.data.IStreamingDataInterface;
import org.sensorhub.api.processing.IStreamProcessModule;
import org.sensorhub.impl.common.BasicEventHandler;
import org.vast.swe.SWEHelper;

class DummyOutput
implements IStreamingDataInterface {
    IStreamProcessModule<?> parentProcess;
    IEventHandler eventHandler;
    DataComponent outputDef;
    DataEncoding outputEncoding;
    DataBlock lastRecord;
    long lastRecordTime = Long.MIN_VALUE;
    double avgSamplingPeriod = 1.0;
    int avgSampleCount = 0;

    protected DummyOutput(IStreamProcessModule<?> parentProcess, DataComponent outputDef) {
        this.parentProcess = parentProcess;
        this.outputDef = outputDef;
        this.outputEncoding = SWEHelper.getDefaultEncoding((DataComponent)outputDef);
        this.eventHandler = new BasicEventHandler();
    }

    public void sendOutput(DataBlock dataBlk) {
        this.lastRecord = dataBlk;
        this.lastRecordTime = System.currentTimeMillis();
        DataEvent outputEvent = new DataEvent(this.lastRecordTime, (IStreamingDataInterface)this, new DataBlock[]{dataBlk});
        this.eventHandler.publishEvent((Event)outputEvent);
    }

    public IStreamProcessModule<?> getParentModule() {
        return this.parentProcess;
    }

    public String getName() {
        return this.outputDef.getName();
    }

    public boolean isEnabled() {
        return true;
    }

    public DataComponent getRecordDescription() {
        return this.outputDef;
    }

    public DataEncoding getRecommendedEncoding() {
        return this.outputEncoding;
    }

    public DataBlock getLatestRecord() {
        return this.lastRecord;
    }

    public long getLatestRecordTime() {
        return this.lastRecordTime;
    }

    public double getAverageSamplingPeriod() {
        return this.avgSamplingPeriod;
    }

    public void registerListener(IEventListener listener) {
        this.eventHandler.registerListener(listener);
    }

    public void unregisterListener(IEventListener listener) {
        this.eventHandler.unregisterListener(listener);
    }
}

