/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.test.processing;

import net.opengis.swe.v20.DataBlock;
import net.opengis.swe.v20.DataComponent;
import org.sensorhub.api.common.SensorHubException;
import org.sensorhub.api.data.DataEvent;
import org.sensorhub.api.data.IStreamingDataInterface;
import org.sensorhub.api.module.ModuleConfig;
import org.sensorhub.api.processing.DataSourceConfig;
import org.sensorhub.api.processing.IStreamProcessModule;
import org.sensorhub.api.processing.ProcessException;
import org.sensorhub.api.processing.StreamProcessConfig;
import org.sensorhub.impl.processing.AbstractStreamProcess;
import org.sensorhub.test.processing.DummyOutput;
import org.vast.data.QuantityImpl;
import org.vast.process.DataQueue;

public class DummyProcessFixedIO
extends AbstractStreamProcess<StreamProcessConfig> {
    public static final String OUTPUT_PREFIX = "processed_";
    public static final String INPUT_NAME = "input1";
    public static final String OUTPUT_NAME = "processed_input1";

    public void init(StreamProcessConfig config) throws SensorHubException {
        QuantityImpl input = new QuantityImpl();
        DataComponent output = input.copy();
        input.setName(INPUT_NAME);
        this.inputs.put(INPUT_NAME, input);
        output.setName(OUTPUT_NAME);
        this.addOutput(new DummyOutput((IStreamProcessModule<?>)this, output));
        super.init((ModuleConfig)config);
    }

    protected void process(DataEvent lastEvent) throws ProcessException {
        try {
            IStreamingDataInterface srcInterface = lastEvent.getSource();
            for (DataQueue q : ((AbstractStreamProcess.InputData)this.streamSources.get(srcInterface)).getDataQueues()) {
                if (!q.isDataAvailable()) continue;
                DataBlock newData = q.get().clone();
                for (int i = 0; i < newData.getAtomCount(); ++i) {
                    newData.setDoubleValue(i, newData.getDoubleValue(i) * 2.0);
                }
                String outputName = OUTPUT_PREFIX + q.getDestinationComponent().getName();
                ((DummyOutput)this.outputInterfaces.get(outputName)).sendOutput(newData);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isCompatibleDataSource(DataSourceConfig dataSource) {
        return true;
    }

    public boolean isPauseSupported() {
        return false;
    }
}

