/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.test.processing;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import net.opengis.swe.v20.DataEncoding;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.sensorhub.api.common.Event;
import org.sensorhub.api.common.IEventListener;
import org.sensorhub.api.data.DataEvent;
import org.sensorhub.api.data.IStreamingDataInterface;
import org.sensorhub.api.module.IModule;
import org.sensorhub.api.module.ModuleConfig;
import org.sensorhub.api.processing.DataSourceConfig;
import org.sensorhub.api.processing.IStreamProcessModule;
import org.sensorhub.api.processing.StreamProcessConfig;
import org.sensorhub.api.processing.StreamingDataSourceConfig;
import org.sensorhub.api.sensor.ISensorDataInterface;
import org.sensorhub.api.sensor.ISensorModule;
import org.sensorhub.api.sensor.SensorConfig;
import org.sensorhub.impl.SensorHub;
import org.sensorhub.impl.processing.SMLStreamProcess;
import org.sensorhub.impl.processing.SMLStreamProcessConfig;
import org.sensorhub.test.processing.DummyProcessAutoIO;
import org.sensorhub.test.processing.DummyProcessFixedIO;
import org.sensorhub.test.sensor.FakeSensor;
import org.sensorhub.test.sensor.FakeSensorData;
import org.vast.cdm.common.DataStreamWriter;
import org.vast.data.TextEncodingImpl;
import org.vast.sensorML.ProcessLoader;
import org.vast.sensorML.SMLUtils;
import org.vast.sensorML.test.TestSMLProcessing;
import org.vast.swe.AsciiDataWriter;

public class TestStreamProcess
implements IEventListener {
    static String FAKE_SENSOR1_ID = "FAKE_SENSOR1";
    static String NAME_OUTPUT1 = "weather";
    static final double SAMPLING_PERIOD = 0.1;
    static final int SAMPLE_COUNT = 10;
    static final String auto = "AUTO_CREATE";
    DataStreamWriter writer;
    int eventCount = 0;

    @Before
    public void setupFramework() throws Exception {
        SensorHub.getInstance();
        URL processMapUrl = TestSMLProcessing.class.getResource("ProcessMap.xml");
        ProcessLoader.loadMaps((String)processMapUrl.toString(), (boolean)false);
    }

    protected ISensorModule<?> createSensorDataSource1() throws Exception {
        SensorConfig sensorCfg = new SensorConfig();
        sensorCfg.autoStart = false;
        sensorCfg.moduleClass = FakeSensor.class.getCanonicalName();
        sensorCfg.id = FAKE_SENSOR1_ID;
        sensorCfg.name = "Sensor1";
        IModule sensor = SensorHub.getInstance().getModuleRegistry().loadModule((ModuleConfig)sensorCfg);
        FakeSensorData sensorOutput = new FakeSensorData((FakeSensor)sensor, NAME_OUTPUT1, 10, 0.1, 10);
        ((FakeSensor)sensor).setDataInterfaces(new ISensorDataInterface[]{sensorOutput});
        return (FakeSensor)sensor;
    }

    protected StreamingDataSourceConfig buildDataSourceConfig(IModule<?> srcModule, String[] srcPaths, String[] destPaths) throws Exception {
        StreamingDataSourceConfig dataSrcCfg = new StreamingDataSourceConfig();
        dataSrcCfg.producerID = srcModule.getLocalID();
        for (int i = 0; i < srcPaths.length; ++i) {
            DataSourceConfig.InputLinkConfig inputLink = new DataSourceConfig.InputLinkConfig();
            inputLink.source = NAME_OUTPUT1 + srcPaths[i];
            inputLink.destination = destPaths[i];
            dataSrcCfg.inputConnections.add(inputLink);
        }
        return dataSrcCfg;
    }

    protected IStreamProcessModule<?> createStreamProcess(Class<?> processClass, StreamingDataSourceConfig ... dataSources) throws Exception {
        StreamProcessConfig processCfg = new StreamProcessConfig();
        processCfg.autoStart = false;
        processCfg.name = "Process #1";
        processCfg.moduleClass = processClass.getCanonicalName();
        for (StreamingDataSourceConfig dataSrc : dataSources) {
            processCfg.dataSources.add(dataSrc);
        }
        IStreamProcessModule process = (IStreamProcessModule)SensorHub.getInstance().getModuleRegistry().loadModule((ModuleConfig)processCfg);
        process.init((ModuleConfig)processCfg);
        return process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runProcess(IStreamProcessModule<?> process) throws Exception {
        this.writer = new AsciiDataWriter();
        this.writer.setDataEncoding((DataEncoding)new TextEncodingImpl(",", ""));
        this.writer.setOutput((OutputStream)System.out);
        process.start();
        new SMLUtils("2.0").writeProcess((OutputStream)System.out, process.getCurrentDescription(), true);
        for (IStreamingDataInterface output : process.getAllOutputs().values()) {
            output.registerListener((IEventListener)this);
        }
        SensorHub.getInstance().getModuleRegistry().getModuleById(FAKE_SENSOR1_ID).start();
        TestStreamProcess testStreamProcess = this;
        synchronized (testStreamProcess) {
            while (this.eventCount < 10) {
                this.wait();
            }
        }
        System.out.println();
    }

    @Test
    public void testDummyProcessAutoIOAll() throws Exception {
        ISensorModule<?> sensor1 = this.createSensorDataSource1();
        IStreamProcessModule<?> process = this.createStreamProcess(DummyProcessAutoIO.class, this.buildDataSourceConfig((IModule<?>)sensor1, new String[]{"/"}, new String[]{auto}));
        this.runProcess(process);
    }

    @Test
    public void testDummyProcessAutoIOOneField() throws Exception {
        ISensorModule<?> sensor1 = this.createSensorDataSource1();
        IStreamProcessModule<?> process = this.createStreamProcess(DummyProcessAutoIO.class, this.buildDataSourceConfig((IModule<?>)sensor1, new String[]{"/windSpeed"}, new String[]{auto}));
        this.runProcess(process);
    }

    @Test
    public void testDummyProcessAutoIOTwoFields() throws Exception {
        ISensorModule<?> sensor1 = this.createSensorDataSource1();
        IStreamProcessModule<?> process = this.createStreamProcess(DummyProcessAutoIO.class, this.buildDataSourceConfig((IModule<?>)sensor1, new String[]{"/windSpeed", "/temp"}, new String[]{auto, auto}));
        this.runProcess(process);
    }

    @Test
    public void testDummyProcessFixedIO() throws Exception {
        ISensorModule<?> sensor1 = this.createSensorDataSource1();
        IStreamProcessModule<?> process = this.createStreamProcess(DummyProcessFixedIO.class, this.buildDataSourceConfig((IModule<?>)sensor1, new String[]{"/press"}, new String[]{"input1"}));
        this.runProcess(process);
    }

    protected IStreamProcessModule<?> createSMLProcess(String smlUrl, StreamingDataSourceConfig ... dataSources) throws Exception {
        SMLStreamProcessConfig processCfg = new SMLStreamProcessConfig();
        processCfg.autoStart = false;
        processCfg.name = "SensorML Process #1";
        processCfg.moduleClass = SMLStreamProcess.class.getCanonicalName();
        processCfg.sensorML = smlUrl;
        for (StreamingDataSourceConfig dataSrc : dataSources) {
            processCfg.dataSources.add(dataSrc);
        }
        IStreamProcessModule process = (IStreamProcessModule)SensorHub.getInstance().getModuleRegistry().loadModule((ModuleConfig)processCfg);
        process.init((ModuleConfig)processCfg);
        for (IStreamingDataInterface output : process.getAllOutputs().values()) {
            output.registerListener((IEventListener)this);
        }
        return process;
    }

    @Test
    public void testSMLSimpleProcess() throws Exception {
        ISensorModule<?> sensor1 = this.createSensorDataSource1();
        String testResource = "examples_v20/LinearInterpolator.xml";
        IStreamProcessModule<?> process = this.createSMLProcess(TestSMLProcessing.class.getResource(testResource).toString(), this.buildDataSourceConfig((IModule<?>)sensor1, new String[]{"/press"}, new String[]{"x"}));
        this.runProcess(process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event<?> e) {
        if (e instanceof DataEvent) {
            try {
                System.out.print(((DataEvent)e).getSource().getName() + ": ");
                this.writer.setDataComponents(((DataEvent)e).getRecordDescription());
                this.writer.reset();
                this.writer.write(((DataEvent)e).getRecords()[0]);
                this.writer.flush();
                System.out.println();
                ++this.eventCount;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            TestStreamProcess testStreamProcess = this;
            synchronized (testStreamProcess) {
                this.notify();
            }
        }
    }

    @After
    public void cleanup() {
        try {
            SensorHub.getInstance().getModuleRegistry().shutdown(false, false);
            SensorHub.clearInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

