/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.test.sensor;

import net.opengis.gml.v32.Point;
import net.opengis.gml.v32.impl.PointImpl;
import net.opengis.sensorml.v20.PhysicalSystem;
import org.sensorhub.api.common.SensorHubException;
import org.sensorhub.api.module.ModuleEvent;
import org.sensorhub.api.sensor.ISensorControlInterface;
import org.sensorhub.api.sensor.ISensorDataInterface;
import org.sensorhub.api.sensor.SensorConfig;
import org.sensorhub.api.sensor.SensorException;
import org.sensorhub.impl.sensor.AbstractSensorModule;
import org.sensorhub.test.sensor.IFakeSensorOutput;

public class FakeSensor
extends AbstractSensorModule<SensorConfig> {
    String sensorUID = "urn:sensors:mysensor:001";

    public void setSensorUID(String sensorUID) {
        this.sensorUID = sensorUID;
    }

    public void setDataInterfaces(ISensorDataInterface ... outputs) throws SensorException {
        for (ISensorDataInterface o : outputs) {
            this.addOutput(o, false);
        }
    }

    public void setControlInterfaces(ISensorControlInterface ... inputs) throws SensorException {
        for (ISensorControlInterface i : inputs) {
            this.addControlInput(i);
        }
    }

    public void updateConfig(SensorConfig config) throws SensorHubException {
    }

    public void init() throws SensorHubException {
    }

    public void start() throws SensorHubException {
        for (ISensorDataInterface o : this.getObservationOutputs().values()) {
            ((IFakeSensorOutput)o).start();
        }
    }

    public void stop() throws SensorHubException {
        for (ISensorDataInterface o : this.getObservationOutputs().values()) {
            ((IFakeSensorOutput)o).stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSensorDescription() {
        Object object = this.sensorDescLock;
        synchronized (object) {
            super.updateSensorDescription();
            this.sensorDescription.setUniqueIdentifier(this.sensorUID);
            PointImpl pos = new PointImpl(3);
            pos.setId("P01");
            pos.setSrsName("http://www.opengis.net/def/crs/EPSG/0/4979");
            pos.setPos(new double[]{45.6, 2.3, 193.2});
            ((PhysicalSystem)this.sensorDescription).addPositionAsPoint((Point)pos);
        }
    }

    public boolean isConnected() {
        return true;
    }

    public void cleanup() throws SensorHubException {
    }

    public void setStartedState() {
        this.setState(ModuleEvent.ModuleState.STARTED);
    }
}

