/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.test.sensor;

import net.opengis.swe.v20.DataBlock;
import net.opengis.swe.v20.DataComponent;
import net.opengis.swe.v20.DataConstraint;
import org.sensorhub.api.common.CommandStatus;
import org.sensorhub.api.sensor.ISensorControlInterface;
import org.sensorhub.api.sensor.ISensorModule;
import org.sensorhub.api.sensor.SensorException;
import org.sensorhub.impl.sensor.AbstractSensorControl;
import org.sensorhub.test.sensor.FakeSensor;
import org.vast.data.AllowedTokensImpl;
import org.vast.data.CategoryImpl;
import org.vast.data.DataRecordImpl;
import org.vast.data.QuantityImpl;

public class FakeSensorControl1
extends AbstractSensorControl<FakeSensor>
implements ISensorControlInterface {
    String name = "command1";
    int counter = 1;

    public FakeSensorControl1(FakeSensor parentSensor) {
        super((ISensorModule)parentSensor);
    }

    public String getName() {
        return this.name;
    }

    public DataComponent getCommandDescription() {
        DataRecordImpl record = new DataRecordImpl(3);
        record.setName(this.name);
        record.setDefinition("urn:blabla:command");
        QuantityImpl q = new QuantityImpl();
        q.setDefinition("urn:blabla:samplingPeriod");
        q.getUom().setCode("s");
        record.addComponent("samplingPeriod", (DataComponent)q);
        CategoryImpl c = new CategoryImpl();
        c.setDefinition("urn:blabla:sensitivity");
        AllowedTokensImpl tokens = new AllowedTokensImpl();
        tokens.addValue("HIGH");
        tokens.addValue("LOW");
        c.setConstraint((DataConstraint)tokens);
        record.addComponent("sens", (DataComponent)c);
        return record;
    }

    public CommandStatus execCommand(DataBlock command) throws SensorException {
        return new CommandStatus(String.format("%03d", this.counter++), CommandStatus.StatusCode.COMPLETED);
    }
}

