/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.test.sensor;

import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingDeque;
import net.opengis.swe.v20.DataBlock;
import net.opengis.swe.v20.DataComponent;
import net.opengis.swe.v20.DataEncoding;
import org.sensorhub.api.common.Event;
import org.sensorhub.api.common.IEventListener;
import org.sensorhub.api.sensor.ISensorDataInterface;
import org.sensorhub.api.sensor.ISensorModule;
import org.sensorhub.api.sensor.SensorDataEvent;
import org.sensorhub.api.sensor.SensorException;
import org.sensorhub.impl.sensor.AbstractSensorOutput;
import org.sensorhub.test.sensor.FakeSensor;
import org.sensorhub.test.sensor.IFakeSensorOutput;
import org.vast.data.DataBlockDouble;
import org.vast.data.DataRecordImpl;
import org.vast.data.QuantityImpl;
import org.vast.data.TextEncodingImpl;
import org.vast.data.TimeImpl;

public class FakeSensorData
extends AbstractSensorOutput<FakeSensor>
implements IFakeSensorOutput {
    String name;
    DataComponent outputStruct;
    DataEncoding outputEncoding;
    int maxSampleCount;
    int sampleCount;
    int bufferSize;
    double samplingPeriod;
    Deque<DataBlock> dataQueue;
    Timer timer;
    TimerTask sensorTask;
    boolean started;
    boolean hasListeners;

    public FakeSensorData(FakeSensor sensor, String name) {
        this(sensor, name, 1, 1.0, 5);
    }

    public FakeSensorData(FakeSensor sensor, String name, int bufferSize, double samplingPeriod, int maxSampleCount) {
        super(name, (ISensorModule)sensor);
        this.name = name;
        this.bufferSize = bufferSize;
        this.samplingPeriod = samplingPeriod;
        this.dataQueue = new LinkedBlockingDeque<DataBlock>(bufferSize);
        this.maxSampleCount = maxSampleCount;
        this.init();
    }

    public void init() {
        this.outputStruct = new DataRecordImpl(3);
        this.outputStruct.setName(this.name);
        this.outputStruct.setDefinition("urn:blabla:weatherData");
        TimeImpl time = new TimeImpl();
        time.setDefinition("http://www.opengis.net/def/property/OGC/0/SamplingTime");
        time.getUom().setHref("http://www.opengis.net/def/uom/ISO-8601/0/Gregorian");
        this.outputStruct.addComponent("time", (DataComponent)time);
        QuantityImpl temp = new QuantityImpl();
        temp.setDefinition("urn:blabla:temperature");
        temp.getUom().setCode("Cel");
        this.outputStruct.addComponent("temp", (DataComponent)temp);
        QuantityImpl wind = new QuantityImpl();
        wind.setDefinition("urn:blabla:windSpeed");
        wind.getUom().setCode("m/s");
        this.outputStruct.addComponent("windSpeed", (DataComponent)wind);
        QuantityImpl press = new QuantityImpl();
        press.setDefinition("urn:blabla:pressure");
        press.getUom().setCode("hPa");
        this.outputStruct.addComponent("press", (DataComponent)press);
        this.outputEncoding = new TextEncodingImpl(",", "\n");
    }

    public int getMaxSampleCount() {
        return this.maxSampleCount;
    }

    @Override
    public void start() {
        if (this.hasListeners) {
            this.startSending();
        }
        this.started = true;
    }

    protected void startSending() {
        if (this.timer == null) {
            this.sensorTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (FakeSensorData.this.sampleCount >= FakeSensorData.this.maxSampleCount) {
                        return;
                    }
                    Deque<DataBlock> deque = FakeSensorData.this.dataQueue;
                    synchronized (deque) {
                        if (Math.random() > 0.8) {
                            return;
                        }
                        double samplingTime = (double)System.currentTimeMillis() / 1000.0;
                        DataBlockDouble data = new DataBlockDouble(4);
                        data.setDoubleValue(0, samplingTime);
                        data.setDoubleValue(1, 1.0 + (double)((int)(Math.random() * 100.0)) / 1000.0);
                        data.setDoubleValue(2, 2.0 + (double)((int)(Math.random() * 100.0)) / 1000.0);
                        data.setDoubleValue(3, 3.0 + (double)((int)(Math.random() * 100.0)) / 1000.0);
                        ++FakeSensorData.this.sampleCount;
                        System.out.println("Record #" + FakeSensorData.this.sampleCount + " generated");
                        if (FakeSensorData.this.sampleCount >= FakeSensorData.this.maxSampleCount) {
                            this.cancel();
                        }
                        if (FakeSensorData.this.dataQueue.size() == FakeSensorData.this.bufferSize) {
                            FakeSensorData.this.dataQueue.remove();
                        }
                        FakeSensorData.this.dataQueue.offer((DataBlock)data);
                        FakeSensorData.this.latestRecordTime = System.currentTimeMillis();
                        FakeSensorData.this.eventHandler.publishEvent((Event)new SensorDataEvent(FakeSensorData.this.latestRecordTime, (ISensorDataInterface)FakeSensorData.this, new DataBlock[]{data}));
                    }
                }
            };
            this.timer = new Timer(this.name, true);
            this.timer.scheduleAtFixedRate(this.sensorTask, 0L, (long)(this.samplingPeriod * 1000.0));
        }
    }

    @Override
    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
    }

    public boolean isEnabled() {
        return this.sampleCount < this.maxSampleCount;
    }

    public boolean isStorageSupported() {
        return this.bufferSize > 0;
    }

    public double getAverageSamplingPeriod() {
        return this.samplingPeriod;
    }

    public DataComponent getRecordDescription() {
        return this.outputStruct;
    }

    public DataEncoding getRecommendedEncoding() {
        return this.outputEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBlock getLatestRecord() {
        Deque<DataBlock> deque = this.dataQueue;
        synchronized (deque) {
            return this.dataQueue.peekLast();
        }
    }

    public int getStorageCapacity() throws SensorException {
        return this.bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAvailableRecords() throws SensorException {
        Deque<DataBlock> deque = this.dataQueue;
        synchronized (deque) {
            return this.dataQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataBlock> getLatestRecords(int maxRecords, boolean clear) throws SensorException {
        Deque<DataBlock> deque = this.dataQueue;
        synchronized (deque) {
            ArrayList<DataBlock> records = new ArrayList<DataBlock>(maxRecords);
            if (clear) {
                for (int i = 0; i < maxRecords; ++i) {
                    records.add(0, this.dataQueue.pollLast());
                }
            } else {
                Iterator<DataBlock> it = this.dataQueue.descendingIterator();
                for (int i = 0; it.hasNext() && i < maxRecords; ++i) {
                    records.add(0, it.next());
                }
            }
            return records;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataBlock> getAllRecords(boolean clear) throws SensorException {
        Deque<DataBlock> deque = this.dataQueue;
        synchronized (deque) {
            ArrayList<DataBlock> records = new ArrayList<DataBlock>();
            if (clear) {
                while (!this.dataQueue.isEmpty()) {
                    records.add(0, this.dataQueue.poll());
                }
            } else {
                for (DataBlock data : this.dataQueue) {
                    records.add(data);
                }
            }
            return records;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int clearAllRecords() throws SensorException {
        Deque<DataBlock> deque = this.dataQueue;
        synchronized (deque) {
            int numRecords = this.dataQueue.size();
            this.dataQueue.clear();
            return numRecords;
        }
    }

    public void registerListener(IEventListener listener) {
        super.registerListener(listener);
        if (this.started) {
            this.startSending();
        }
        this.hasListeners = true;
    }
}

