/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.test.sensor;

import net.opengis.sensorml.v20.PhysicalSystem;
import net.opengis.sensorml.v20.SpatialFrame;
import org.sensorhub.api.common.SensorHubException;
import org.sensorhub.api.module.ModuleEvent;
import org.sensorhub.api.sensor.ISensorControlInterface;
import org.sensorhub.api.sensor.ISensorDataInterface;
import org.sensorhub.api.sensor.SensorException;
import org.sensorhub.impl.sensor.AbstractSensorModule;
import org.sensorhub.test.sensor.IFakeSensorOutput;
import org.sensorhub.test.sensor.SensorConfigWithPos;
import org.vast.sensorML.SMLFactory;

public class FakeSensorWithPos
extends AbstractSensorModule<SensorConfigWithPos> {
    public FakeSensorWithPos() {
        this.uniqueID = "urn:sensors:mysensor:001";
        this.xmlID = "SENSOR1";
    }

    public void setSensorUID(String sensorUID) {
        this.uniqueID = sensorUID;
    }

    public void setDataInterfaces(ISensorDataInterface ... outputs) throws SensorException {
        for (ISensorDataInterface o : outputs) {
            this.addOutput(o, false);
        }
    }

    public void setControlInterfaces(ISensorControlInterface ... inputs) throws SensorException {
        for (ISensorControlInterface i : inputs) {
            this.addControlInput(i);
        }
    }

    public void updateConfig(SensorConfigWithPos config) throws SensorHubException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSensorDescription() {
        Object object = this.sensorDescLock;
        synchronized (object) {
            super.updateSensorDescription();
            SMLFactory smlFac = new SMLFactory();
            SpatialFrame localRefFrame = smlFac.newSpatialFrame();
            localRefFrame.setId(this.getLocalFrameID());
            localRefFrame.setOrigin("Frame Origin");
            localRefFrame.addAxis("X", "The X axis");
            localRefFrame.addAxis("Y", "The Y axis");
            localRefFrame.addAxis("Z", "The Z axis");
            ((PhysicalSystem)this.sensorDescription).addLocalReferenceFrame(localRefFrame);
        }
    }

    public void start() throws SensorHubException {
        for (ISensorDataInterface o : this.getObservationOutputs().values()) {
            ((IFakeSensorOutput)o).start();
        }
    }

    public void stop() throws SensorHubException {
        for (ISensorDataInterface o : this.getObservationOutputs().values()) {
            ((IFakeSensorOutput)o).stop();
        }
    }

    public boolean isConnected() {
        return true;
    }

    public void cleanup() throws SensorHubException {
    }

    public void setStartedState() {
        this.setState(ModuleEvent.ModuleState.STARTED);
    }
}

