/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.test.sensor;

import java.io.OutputStream;
import net.opengis.gml.v32.AbstractFeature;
import net.opengis.gml.v32.Point;
import net.opengis.sensorml.v20.AbstractPhysicalProcess;
import net.opengis.sensorml.v20.AbstractProcess;
import net.opengis.swe.v20.DataBlock;
import net.opengis.swe.v20.DataRecord;
import net.opengis.swe.v20.Vector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sensorhub.test.sensor.FakeSensorWithPos;
import org.sensorhub.test.sensor.SensorConfigWithPos;
import org.vast.ogc.gml.GMLUtils;
import org.vast.sensorML.SMLUtils;

public class TestSensorPosition {
    FakeSensorWithPos sensor;
    double lat = 34.56;
    double lon = 1.2;
    double alt = 568.0;
    double heading = 56.0;
    double pitch = -12.3;
    double roll = 3.6;

    @Before
    public void setup() throws Exception {
        this.sensor = new FakeSensorWithPos();
    }

    protected void checkFoiLocation() throws Exception {
        AbstractFeature f = this.sensor.getCurrentFeatureOfInterest();
        new GMLUtils("3.2").writeFeature((OutputStream)System.out, f, true);
        System.out.println('\n');
        Assert.assertTrue((String)"FoI must be a point", (boolean)(f.getLocation() instanceof Point));
        double[] loc = ((Point)f.getLocation()).getPos();
        Assert.assertEquals((String)"Wrong latitude value", (double)this.lat, (double)loc[0], (double)0.0);
        Assert.assertEquals((String)"Wrong longitude value", (double)this.lon, (double)loc[1], (double)0.0);
        Assert.assertEquals((String)"Wrong altitude value", (double)this.alt, (double)loc[2], (double)0.0);
        Assert.assertEquals((String)"Wrong CRS", (Object)"http://www.opengis.net/def/crs/EPSG/0/4979", (Object)f.getLocation().getSrsName());
    }

    protected void checkSmlLocationVector(Vector vector) throws Exception {
        DataBlock posData = vector.getData();
        Assert.assertEquals((String)"Wrong latitude value", (double)this.lat, (double)posData.getDoubleValue(0), (double)0.0);
        Assert.assertEquals((String)"Wrong longitude value", (double)this.lon, (double)posData.getDoubleValue(1), (double)0.0);
        Assert.assertEquals((String)"Wrong altitude value", (double)this.alt, (double)posData.getDoubleValue(2), (double)0.0);
    }

    protected void checkSmlOrientationVector(Vector vector) throws Exception {
        DataBlock posData = vector.getData();
        Assert.assertEquals((String)"Wrong heading value", (double)this.heading, (double)posData.getDoubleValue(0), (double)0.0);
        Assert.assertEquals((String)"Wrong pitch value", (double)this.pitch, (double)posData.getDoubleValue(1), (double)0.0);
        Assert.assertEquals((String)"Wrong roll value", (double)this.roll, (double)posData.getDoubleValue(2), (double)0.0);
    }

    @Test
    public void testStaticLocation() throws Exception {
        SensorConfigWithPos config = new SensorConfigWithPos();
        config.id = "TEST_SENSOR";
        config.name = "Temp Sensor";
        config.setLocation(this.lat, this.lon, this.alt);
        this.sensor.init(config);
        this.checkFoiLocation();
        AbstractPhysicalProcess sensorDesc = this.sensor.getCurrentDescription();
        new SMLUtils("2.0").writeProcess((OutputStream)System.out, (AbstractProcess)sensorDesc, true);
        System.out.println('\n');
        Assert.assertTrue((String)"Location must be a SWE Vector", (boolean)(sensorDesc.getPositionList().get(0) instanceof Vector));
        this.checkSmlLocationVector((Vector)sensorDesc.getPositionList().get(0));
    }

    @Test
    public void testStaticOrientation() throws Exception {
        SensorConfigWithPos config = new SensorConfigWithPos();
        config.id = "TEST_SENSOR";
        config.name = "Temp Sensor";
        config.setOrientation(this.heading, this.pitch, this.roll);
        this.sensor.init(config);
        Assert.assertNull((String)"FoI must be null", (Object)this.sensor.getCurrentFeatureOfInterest());
        AbstractPhysicalProcess sensorDesc = this.sensor.getCurrentDescription();
        new SMLUtils("2.0").writeProcess((OutputStream)System.out, (AbstractProcess)sensorDesc, true);
        System.out.println('\n');
        Assert.assertTrue((String)"Location must be a SWE Vector", (boolean)(sensorDesc.getPositionList().get(0) instanceof Vector));
        this.checkSmlOrientationVector((Vector)sensorDesc.getPositionList().get(0));
    }

    @Test
    public void testStaticLocationAndOrientation() throws Exception {
        SensorConfigWithPos config = new SensorConfigWithPos();
        config.id = "TEST_SENSOR";
        config.name = "Video Camera";
        config.setLocation(this.lat, this.lon, this.alt);
        config.setOrientation(this.heading, this.pitch, this.roll);
        this.sensor.init(config);
        this.checkFoiLocation();
        AbstractPhysicalProcess sensorDesc = this.sensor.getCurrentDescription();
        new SMLUtils("2.0").writeProcess((OutputStream)System.out, (AbstractProcess)sensorDesc, true);
        System.out.println('\n');
        Assert.assertTrue((String)"Location must be a SWE DataRecord", (boolean)(sensorDesc.getPositionList().get(0) instanceof DataRecord));
        DataRecord rec = (DataRecord)sensorDesc.getPositionList().get(0);
        this.checkSmlLocationVector((Vector)rec.getComponent(0));
        this.checkSmlOrientationVector((Vector)rec.getComponent(1));
    }
}

