/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.test.service;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TcpRepeater {
    List<Socket> clientSockets = new ArrayList<Socket>();
    boolean started;
    ServerSocket server;
    Object sync = new Object();
    volatile boolean sending = false;
    byte[] msgBytes;

    TcpRepeater(int port) throws IOException {
        this.server = new ServerSocket(port);
        this.started = true;
        Thread listenThread = new Thread(){

            @Override
            public void run() {
                while (TcpRepeater.this.started) {
                    try {
                        Socket s = TcpRepeater.this.server.accept();
                        TcpRepeater.this.clientSockets.add(s);
                    }
                    catch (IOException e) {
                        System.err.println("Cannot accept client connection");
                        break;
                    }
                }
            }
        };
        listenThread.start();
        Thread sendThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (TcpRepeater.this.started) {
                    Object object = TcpRepeater.this.sync;
                    synchronized (object) {
                        try {
                            TcpRepeater.this.sync.wait();
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        TcpRepeater.this.sending = true;
                    }
                    Iterator<Socket> it = TcpRepeater.this.clientSockets.iterator();
                    while (it.hasNext()) {
                        try {
                            Socket s = it.next();
                            if (s.isClosed()) {
                                it.remove();
                                continue;
                            }
                            if (!s.isConnected()) continue;
                            s.getOutputStream().write(TcpRepeater.this.msgBytes);
                            s.getOutputStream().flush();
                        }
                        catch (IOException iOException) {}
                    }
                    TcpRepeater.this.sending = false;
                }
            }
        };
        sendThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(byte[] msgBytes) throws IOException {
        Object object = this.sync;
        synchronized (object) {
            if (!this.sending) {
                this.msgBytes = (byte[])msgBytes.clone();
                this.sync.notify();
            }
        }
    }

    public void stop() {
        try {
            this.started = false;
            this.server.close();
            for (Socket s : this.clientSockets) {
                s.close();
            }
            this.clientSockets.clear();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

