/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.test.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.sensorhub.api.module.ModuleConfig;
import org.sensorhub.impl.SensorHub;
import org.sensorhub.impl.security.BasicSecurityRealmConfig;
import org.sensorhub.impl.service.HttpServer;
import org.sensorhub.impl.service.HttpServerConfig;

public class TestHttpServer {
    private static String USER_ID = "admin";
    private static String PASSWORD = "pwd";

    private HttpServerConfig startServer(HttpServerConfig.AuthMethod authMethod) throws Exception {
        HttpServerConfig config = new HttpServerConfig();
        config.autoStart = true;
        config.authMethod = authMethod;
        SensorHub.getInstance().getModuleRegistry().loadModule((ModuleConfig)config);
        return config;
    }

    private void addUsers() throws Exception {
        BasicSecurityRealmConfig securityConfig = new BasicSecurityRealmConfig();
        securityConfig.autoStart = true;
        BasicSecurityRealmConfig.UserConfig user = new BasicSecurityRealmConfig.UserConfig();
        user.userID = USER_ID;
        user.password = PASSWORD;
        securityConfig.users.add(user);
        SensorHub.getInstance().getModuleRegistry().loadModule((ModuleConfig)securityConfig);
    }

    @Test
    public void testStartServer() throws Exception {
        this.startServer(null);
    }

    @Test
    public void testDeployServlet() throws Exception {
        HttpServerConfig config = this.startServer(null);
        String testText = "Deploying hot servlet in SensorHub works";
        HttpServer.getInstance().deployServlet(new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
                try {
                    resp.getOutputStream().print("Deploying hot servlet in SensorHub works");
                    resp.getOutputStream().flush();
                }
                catch (IOException e) {
                    throw new ServletException((Throwable)e);
                }
            }
        }, "/junit");
        URL url = new URL("http://localhost:" + config.httpPort + config.servletsRootUrl + "/junit");
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        String resp = reader.readLine();
        System.out.println(resp);
        reader.close();
        Assert.assertTrue((boolean)resp.equals("Deploying hot servlet in SensorHub works"));
    }

    private void testConnect(HttpServerConfig.AuthMethod authMethod) throws Exception {
        this.addUsers();
        HttpServerConfig config = this.startServer(authMethod);
        if (authMethod != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    PasswordAuthentication pa = new PasswordAuthentication(USER_ID, PASSWORD.toCharArray());
                    return pa;
                }
            });
        }
        URL url = new URL("http://localhost:" + config.httpPort + config.servletsRootUrl + "/test");
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        String resp = reader.readLine();
        System.out.println(resp);
        reader.close();
        Assert.assertTrue((boolean)resp.equals("SensorHub web server is up"));
    }

    @Test
    public void testConnectNoAuth() throws Exception {
        this.testConnect(null);
    }

    @Test
    public void testConnectWithBasicAuth() throws Exception {
        this.testConnect(HttpServerConfig.AuthMethod.BASIC);
    }

    @Test
    public void testConnectWithDigestAuth() throws Exception {
        this.testConnect(HttpServerConfig.AuthMethod.DIGEST);
    }

    @After
    public void cleanup() {
        try {
            SensorHub.getInstance().getModuleRegistry().shutdown(false, false);
            HttpServer.getInstance().cleanup();
            SensorHub.clearInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

