/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.test.utils;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.sensorhub.utils.FileUtils;

public class TestFileUtils {
    @Test
    public void testFixFileName() {
        String expected = "my_file_2.dat";
        String msg1 = "File name is unsafe";
        String msg2 = "Incorrectly generated file name";
        String in = "my_file2.dat";
        Assert.assertTrue((String)"File name is safe", (boolean)FileUtils.isSafeFileName((String)in));
        in = "my_file#2.dat";
        Assert.assertFalse((String)msg1, (boolean)FileUtils.isSafeFileName((String)in));
        Assert.assertEquals((String)msg2, (Object)expected, (Object)FileUtils.safeFileName((String)in));
        in = "my:file#2.dat";
        Assert.assertFalse((String)msg1, (boolean)FileUtils.isSafeFileName((String)in));
        Assert.assertEquals((String)msg2, (Object)expected, (Object)FileUtils.safeFileName((String)in));
        in = "my$$file##2.dat";
        Assert.assertFalse((String)msg1, (boolean)FileUtils.isSafeFileName((String)in));
        Assert.assertEquals((String)msg2, (Object)expected, (Object)FileUtils.safeFileName((String)in));
    }

    @Test
    public void testCheckFilePath() {
        char sep = File.separatorChar;
        String msg1 = "File path is valid";
        String msg2 = "File path is invalid";
        String in = sep + "folder" + sep + "my_file2.dat";
        Assert.assertTrue((String)msg1, (boolean)FileUtils.isSafeFilePath((String)in));
        in = "c:" + sep + "folder" + sep + "my_file2.dat";
        Assert.assertTrue((String)msg1, (boolean)FileUtils.isSafeFilePath((String)in));
        in = ":c:" + sep + "folder" + sep + "my_file2.dat";
        Assert.assertFalse((String)msg1, (boolean)FileUtils.isSafeFilePath((String)in));
        in = "/drive/folder/my_file#2.dat";
        Assert.assertFalse((String)msg2, (boolean)FileUtils.isSafeFilePath((String)in));
    }
}

