/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.impl.sensor.fakecam;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentHeaderBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentHeaderBox;
import com.coremedia.iso.boxes.fragment.TrackRunBox;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import net.opengis.swe.v20.BinaryBlock;
import net.opengis.swe.v20.BinaryEncoding;
import net.opengis.swe.v20.ByteEncoding;
import net.opengis.swe.v20.DataArray;
import net.opengis.swe.v20.DataBlock;
import net.opengis.swe.v20.DataComponent;
import net.opengis.swe.v20.DataEncoding;
import net.opengis.swe.v20.DataRecord;
import net.opengis.swe.v20.DataType;
import net.opengis.swe.v20.Time;
import org.sensorhub.api.common.Event;
import org.sensorhub.api.common.SensorHubException;
import org.sensorhub.api.sensor.ISensorDataInterface;
import org.sensorhub.api.sensor.ISensorModule;
import org.sensorhub.api.sensor.SensorDataEvent;
import org.sensorhub.impl.sensor.AbstractSensorOutput;
import org.sensorhub.impl.sensor.fakecam.FakeCamConfig;
import org.sensorhub.impl.sensor.fakecam.FakeCamSensor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vast.data.CountImpl;
import org.vast.data.DataBlockCompressed;
import org.vast.data.SWEFactory;

public class FakeCamOutput
extends AbstractSensorOutput<FakeCamSensor> {
    private static final Logger log = LoggerFactory.getLogger(FakeCamOutput.class);
    DataComponent videoDataStruct;
    BinaryEncoding encoding;
    boolean sendData;
    Timer timer;
    IsoFile mp4File;
    Iterator<Box> mp4Boxes;
    ByteArrayOutputStream videoFrameBuffer;
    long sampleCounter;

    public FakeCamOutput(FakeCamSensor parentSensor) {
        super((ISensorModule)parentSensor);
    }

    public String getName() {
        return "videoOut";
    }

    protected void init() {
        int[] imgSize = this.getVideoSize();
        SWEFactory fac = new SWEFactory();
        this.videoDataStruct = fac.newDataRecord(2);
        this.videoDataStruct.setName(this.getName());
        Time time = fac.newTime();
        time.getUom().setHref("http://www.opengis.net/def/uom/ISO-8601/0/Gregorian");
        time.setDefinition("http://www.opengis.net/def/property/OGC/0/SamplingTime");
        this.videoDataStruct.addComponent("time", (DataComponent)time);
        DataArray img = fac.newDataArray(imgSize[1]);
        img.setDefinition("http://sensorml.com/ont/swe/property/VideoFrame");
        this.videoDataStruct.addComponent("videoFrame", (DataComponent)img);
        DataArray imgRow = fac.newDataArray(imgSize[0]);
        img.addComponent("row", (DataComponent)imgRow);
        DataRecord imgPixel = fac.newDataRecord(3);
        imgPixel.addComponent("red", (DataComponent)new CountImpl(DataType.BYTE));
        imgPixel.addComponent("green", (DataComponent)new CountImpl(DataType.BYTE));
        imgPixel.addComponent("blue", (DataComponent)new CountImpl(DataType.BYTE));
        imgRow.addComponent("pixel", (DataComponent)imgPixel);
        this.encoding = fac.newBinaryEncoding();
        this.encoding.setByteEncoding(ByteEncoding.RAW);
        this.encoding.setByteOrder(ByteOrder.BIG_ENDIAN);
        BinaryBlock blockEnc = fac.newBinaryBlock();
        blockEnc.setRef("/");
        blockEnc.setCompression("H264");
        this.encoding.addMemberAsBlock(blockEnc);
    }

    private int[] getVideoSize() {
        return new int[]{640, 480};
    }

    private void sendMeasurement() {
        try {
            this.videoFrameBuffer.reset();
            WritableByteChannel byteChannel = Channels.newChannel(this.videoFrameBuffer);
            if (this.mp4Boxes == null || !this.mp4Boxes.hasNext()) {
                this.mp4Boxes = this.mp4File.getBoxes().iterator();
            }
            while (this.mp4Boxes.hasNext()) {
                Box currentBox = this.mp4Boxes.next();
                if (currentBox instanceof MovieBox) {
                    log.trace(((MovieBox)currentBox).getMovieHeaderBox().toString());
                }
                if (currentBox instanceof MovieFragmentBox) {
                    ++this.sampleCounter;
                    ((MovieFragmentHeaderBox)((MovieFragmentBox)currentBox).getBoxes(MovieFragmentHeaderBox.class).get(0)).setSequenceNumber(this.sampleCounter);
                    ((TrackFragmentHeaderBox)((MovieFragmentBox)currentBox).getTrackFragmentHeaderBoxes().get(0)).setBaseDataOffset(-1L);
                    ((TrackFragmentHeaderBox)((MovieFragmentBox)currentBox).getTrackFragmentHeaderBoxes().get(0)).setDefaultSampleDuration(4000L);
                    ((TrackRunBox)((MovieFragmentBox)currentBox).getTrackRunBoxes().get(0)).setDataOffset(216);
                    log.trace(((MovieFragmentHeaderBox)((MovieFragmentBox)currentBox).getBoxes(MovieFragmentHeaderBox.class).get(0)).toString());
                    log.trace(((TrackFragmentHeaderBox)((MovieFragmentBox)currentBox).getTrackFragmentHeaderBoxes().get(0)).toString());
                    log.trace(((TrackRunBox)((MovieFragmentBox)currentBox).getTrackRunBoxes().get(0)).toString());
                }
                if (currentBox.getType().equals("moof")) {
                    log.trace("Copying box " + currentBox.getType());
                    currentBox.getBox(byteChannel);
                    continue;
                }
                if (currentBox.getType().equals("mdat")) {
                    log.trace("Copying box " + currentBox.getType());
                    currentBox.getBox(byteChannel);
                    break;
                }
                if (!currentBox.getType().equals("mfra")) continue;
                this.mp4Boxes = this.mp4File.getBoxes().iterator();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        DataBlockCompressed dataBlock = new DataBlockCompressed();
        dataBlock.setUnderlyingObject(this.videoFrameBuffer.toByteArray());
        this.latestRecord = dataBlock;
        this.latestRecordTime = System.currentTimeMillis();
        this.eventHandler.publishEvent((Event)new SensorDataEvent(this.latestRecordTime, (ISensorDataInterface)this, new DataBlock[]{dataBlock}));
    }

    protected void start() throws SensorHubException {
        if (this.timer != null) {
            return;
        }
        this.timer = new Timer();
        String videoFile = ((FakeCamConfig)((FakeCamSensor)this.parentSensor).getConfiguration()).videoFilePath;
        try {
            this.mp4File = new IsoFile(videoFile);
            this.videoFrameBuffer = new ByteArrayOutputStream(10240);
        }
        catch (IOException e) {
            throw new SensorHubException("Error opening video file " + videoFile, (Throwable)e);
        }
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                FakeCamOutput.this.sendMeasurement();
            }
        };
        this.sampleCounter = 0L;
        this.timer.scheduleAtFixedRate(task, 0L, (long)(this.getAverageSamplingPeriod() * 1000.0));
    }

    protected void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public double getAverageSamplingPeriod() {
        return 0.8;
    }

    public DataComponent getRecordDescription() {
        return this.videoDataStruct;
    }

    public DataEncoding getRecommendedEncoding() {
        return this.encoding;
    }
}

