/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.impl.sensor.nmea.gps;

import net.opengis.swe.v20.DataBlock;
import net.opengis.swe.v20.DataComponent;
import net.opengis.swe.v20.DataType;
import org.sensorhub.impl.sensor.nmea.gps.NMEAGpsOutput;
import org.sensorhub.impl.sensor.nmea.gps.NMEAGpsSensor;
import org.vast.swe.SWEHelper;

public class GPSQualityOutput
extends NMEAGpsOutput {
    public GPSQualityOutput(NMEAGpsSensor parentSensor) {
        super(parentSensor);
        this.samplingPeriod = 1.0;
    }

    public String getName() {
        return "gpsQuality";
    }

    protected void init() {
        SWEHelper fac = new SWEHelper();
        this.dataStruct = fac.newDataRecord(3);
        this.dataStruct.setName(this.getName());
        this.dataStruct.addComponent("time", (DataComponent)fac.newTimeStampIsoUTC());
        this.dataStruct.addComponent("numSats", (DataComponent)fac.newCount(SWEHelper.getPropertyUri((String)"GNSS/FixNumSats"), "Number of Satellites", "Number of satellites used in the position fix"));
        this.dataStruct.addComponent("hdop", (DataComponent)fac.newQuantity(SWEHelper.getPropertyUri((String)"GNSS/HDOP"), "HDOP", null, "1", DataType.FLOAT));
        this.dataStruct.addComponent("vdop", (DataComponent)fac.newQuantity(SWEHelper.getPropertyUri((String)"GNSS/VDOP"), "VDOP", null, "1", DataType.FLOAT));
        this.dataStruct.addComponent("herr", (DataComponent)fac.newQuantity(SWEHelper.getPropertyUri((String)"GNSS/HPrecision"), "Horizontal Precision", null, "m", DataType.FLOAT));
        this.dataStruct.addComponent("verr", (DataComponent)fac.newQuantity(SWEHelper.getPropertyUri((String)"GNSS/VPrecision"), "Vertical Precision", null, "m", DataType.FLOAT));
        this.dataEncoding = fac.newTextEncoding(",", "\n");
    }

    @Override
    protected void handleMessage(long msgTime, String msgID, String msg) {
        DataBlock dataBlock = null;
        if (msgID.equals("GSA")) {
            String[] tokens = msg.split(",|\\*");
            if (tokens[1].charAt(0) != 'A' || Double.isNaN(((NMEAGpsSensor)this.parentSensor).lastFixUtcTime)) {
                NMEAGpsSensor.log.debug("GSA: No position fix");
                return;
            }
            int numSats = 0;
            for (int i = 3; i < 15; ++i) {
                if (tokens[i].trim().length() <= 0) continue;
                ++numSats;
            }
            dataBlock = this.getNewDataBlock();
            dataBlock.setDoubleValue(0, ((NMEAGpsSensor)this.parentSensor).lastFixUtcTime);
            dataBlock.setIntValue(1, numSats);
            dataBlock.setFloatValue(2, Float.parseFloat(tokens[16]));
            dataBlock.setFloatValue(3, Float.parseFloat(tokens[17]));
            dataBlock.setFloatValue(4, Float.parseFloat(tokens[16]) * 5.0f);
            dataBlock.setFloatValue(5, Float.parseFloat(tokens[17]) * 5.0f);
        }
        if (dataBlock != null) {
            this.sendOutput(msgTime, dataBlock);
        }
    }
}

