/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.impl.sensor.nmea.gps;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.opengis.swe.v20.DataBlock;
import net.opengis.swe.v20.DataComponent;
import net.opengis.swe.v20.Vector;
import org.sensorhub.impl.sensor.nmea.gps.NMEAGpsOutput;
import org.sensorhub.impl.sensor.nmea.gps.NMEAGpsSensor;
import org.vast.swe.SWEHelper;
import org.vast.util.DateTimeFormat;

public class LLALocationOutput
extends NMEAGpsOutput {
    static final long SECONDS_PER_DAY = 86400L;
    static final long MILLIS_PER_DAY = 86400000L;
    double lastFixUtcDateTime = Double.NaN;
    double lastFixUtcTimeValue = Double.NaN;
    GregorianCalendar cal;

    public LLALocationOutput(NMEAGpsSensor parentSensor) {
        super(parentSensor);
        this.samplingPeriod = 1.0;
        this.cal = new GregorianCalendar();
        this.cal.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public String getName() {
        return "gpsLocation";
    }

    protected void init() {
        SWEHelper fac = new SWEHelper();
        this.dataStruct = fac.newDataRecord(3);
        this.dataStruct.setName(this.getName());
        this.dataStruct.addComponent("time", (DataComponent)fac.newTimeStampIsoUTC());
        Vector locVector = fac.newLocationVectorLLA("http://www.opengis.net/def/property/OGC/0/SensorLocation");
        locVector.setLabel("Location");
        locVector.setDescription("Location measured by GPS device");
        this.dataStruct.addComponent("location", (DataComponent)locVector);
        this.dataEncoding = fac.newTextEncoding(",", "\n");
    }

    @Override
    protected void handleMessage(long msgTime, String msgID, String msg) {
        DataBlock dataBlock = null;
        double now = (double)System.currentTimeMillis() / 1000.0;
        if (Double.isNaN(this.lastFixUtcDateTime) || now - this.lastFixUtcDateTime > 3600.0) {
            this.setLastFixUtcFateTime(now - 3600.0);
        }
        if (msgID.equals("GGA")) {
            String[] tokens = msg.split(",|\\*");
            if (tokens[6].charAt(0) == '0') {
                NMEAGpsSensor.log.debug("GGA: No position fix");
                return;
            }
            String utcTimeToken = tokens[1];
            double utcTime = Double.parseDouble(utcTimeToken);
            if (utcTime == this.lastFixUtcTimeValue) {
                return;
            }
            dataBlock = this.getNewDataBlock();
            dataBlock.setDoubleValue(0, this.toJulianTime(utcTimeToken));
            dataBlock.setDoubleValue(1, this.toDecimalDegrees(tokens[2], tokens[3], false));
            dataBlock.setDoubleValue(2, this.toDecimalDegrees(tokens[4], tokens[5], true));
            dataBlock.setDoubleValue(3, this.toEllipsoidalHeight(tokens[9], tokens[11]));
        } else if (msgID.equals("RMC")) {
            String[] tokens = msg.split(",|\\*");
            if (tokens[2].charAt(0) != 'A') {
                NMEAGpsSensor.log.debug("RMC: Invalid Data");
                return;
            }
            String utcTimeToken = tokens[1];
            double fixTime = this.toJulianTime(utcTimeToken, tokens[9]);
            double utcTime = Double.parseDouble(utcTimeToken);
            if (utcTime == this.lastFixUtcTimeValue) {
                return;
            }
            dataBlock = this.getNewDataBlock();
            dataBlock.setDoubleValue(0, fixTime);
            dataBlock.setDoubleValue(1, this.toDecimalDegrees(tokens[3], tokens[4], false));
            dataBlock.setDoubleValue(2, this.toDecimalDegrees(tokens[5], tokens[6], true));
            dataBlock.setDoubleValue(3, Double.NaN);
        } else if (msgID.equals("GLL")) {
            String[] tokens = msg.split(",|\\*");
            if (tokens[6].charAt(0) != 'A') {
                NMEAGpsSensor.log.debug("GLL: Invalid Data");
                return;
            }
            String utcTimeToken = tokens[5];
            double utcTime = Double.parseDouble(utcTimeToken);
            if (utcTime == this.lastFixUtcTimeValue) {
                return;
            }
            dataBlock = this.getNewDataBlock();
            dataBlock.setDoubleValue(0, this.toJulianTime(utcTimeToken));
            dataBlock.setDoubleValue(1, this.toDecimalDegrees(tokens[1], tokens[2], false));
            dataBlock.setDoubleValue(2, this.toDecimalDegrees(tokens[3], tokens[4], true));
            dataBlock.setDoubleValue(3, Double.NaN);
        } else if (msgID.equals("ZDA")) {
            String[] tokens = msg.split(",|\\*");
            this.cal.set(5, Integer.parseInt(tokens[2]));
            this.cal.set(2, Integer.parseInt(tokens[3]));
            this.cal.set(1, Integer.parseInt(tokens[4]));
            String utcTimeToken = tokens[1];
            this.cal.set(11, Integer.parseInt(utcTimeToken.substring(0, 2)));
            this.cal.set(12, Integer.parseInt(utcTimeToken.substring(2, 4)));
            double seconds = Double.parseDouble(utcTimeToken.substring(4));
            this.cal.set(13, (int)seconds);
            double subSeconds = seconds - Math.floor(seconds);
            this.cal.set(14, (int)(subSeconds * 1000.0));
            this.setLastFixUtcFateTime((double)this.cal.getTimeInMillis() / 1000.0);
        }
        if (dataBlock != null) {
            this.sendOutput(msgTime, dataBlock);
        }
    }

    protected double toJulianTime(String utcTime) {
        int hours = Integer.parseInt(utcTime.substring(0, 2));
        int minutes = Integer.parseInt(utcTime.substring(2, 4));
        double seconds = Double.parseDouble(utcTime.substring(4));
        double secondsAtBeginingOfDay = Math.floor(this.lastFixUtcDateTime / 86400.0) * 86400.0;
        double fixDateTime = secondsAtBeginingOfDay + (double)hours * 3600.0 + (double)minutes * 60.0 + seconds;
        if (fixDateTime < this.lastFixUtcDateTime) {
            fixDateTime += 86400.0;
        }
        this.lastFixUtcTimeValue = Double.parseDouble(utcTime);
        return this.setLastFixUtcFateTime(fixDateTime);
    }

    protected double toJulianTime(String utcTime, String utcDate) {
        this.cal.set(5, Integer.parseInt(utcDate.substring(0, 2)));
        this.cal.set(2, Integer.parseInt(utcDate.substring(2, 4)));
        this.cal.set(1, 2000 + Integer.parseInt(utcDate.substring(4, 6)));
        this.cal.set(11, Integer.parseInt(utcTime.substring(0, 2)));
        this.cal.set(12, Integer.parseInt(utcTime.substring(2, 4)));
        double seconds = Double.parseDouble(utcTime.substring(4));
        this.cal.set(13, (int)seconds);
        double subSeconds = seconds - Math.floor(seconds);
        this.cal.set(14, (int)(subSeconds * 1000.0));
        this.lastFixUtcTimeValue = Double.parseDouble(utcTime);
        return this.setLastFixUtcFateTime((double)this.cal.getTimeInMillis() / 1000.0);
    }

    protected double toDecimalDegrees(String latLon, String signIndicator, boolean lon) {
        double val = Double.NaN;
        int sep = lon ? 3 : 2;
        String integerDegrees = latLon.substring(0, sep);
        String decimalMinutes = latLon.substring(sep);
        val = Double.parseDouble(integerDegrees) + Double.parseDouble(decimalMinutes) / 60.0;
        char dir = signIndicator.charAt(0);
        if (dir == 'S' || dir == 'W') {
            return -val;
        }
        return val;
    }

    protected double setLastFixUtcFateTime(double fixDateTime) {
        ((NMEAGpsSensor)this.parentSensor).lastFixUtcTime = this.lastFixUtcDateTime = fixDateTime;
        if (NMEAGpsSensor.log.isDebugEnabled()) {
            NMEAGpsSensor.log.debug("UTC Date/Time is {}", (Object)new DateTimeFormat().formatIso(fixDateTime, 0));
        }
        return fixDateTime;
    }

    protected double toEllipsoidalHeight(String mslAlt, String geoidSep) {
        return Double.parseDouble(mslAlt) + Double.parseDouble(geoidSep);
    }
}

