/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.impl.sensor.nmea.gps;

import net.opengis.swe.v20.DataBlock;
import net.opengis.swe.v20.DataComponent;
import net.opengis.swe.v20.Quantity;
import org.sensorhub.impl.sensor.nmea.gps.NMEAGpsOutput;
import org.sensorhub.impl.sensor.nmea.gps.NMEAGpsSensor;
import org.vast.swe.SWEHelper;

public class NEDVelocityOutput
extends NMEAGpsOutput {
    private static final double KMH_TO_MS = 0.2777777777777778;

    public NEDVelocityOutput(NMEAGpsSensor parentSensor) {
        super(parentSensor);
        this.samplingPeriod = 1.0;
    }

    public String getName() {
        return "gpsTrack";
    }

    protected void init() {
        SWEHelper fac = new SWEHelper();
        this.dataStruct = fac.newDataRecord(3);
        this.dataStruct.setDefinition(SWEHelper.getPropertyUri((String)"GNSS/TrackData"));
        this.dataStruct.setName(this.getName());
        this.dataStruct.addComponent("time", (DataComponent)fac.newTimeStampIsoUTC());
        Quantity heading = fac.newQuantity(SWEHelper.getPropertyUri((String)"TrackHeading"), "Track Heading", "Track heading relative to true north", "deg");
        heading.setReferenceFrame("http://www.opengis.net/def/crs/OGC/0/NED");
        heading.setAxisID("z");
        this.dataStruct.addComponent("heading", (DataComponent)heading);
        this.dataStruct.addComponent("speed", (DataComponent)fac.newQuantity(SWEHelper.getPropertyUri((String)"GroundSpeed"), "Ground Speed", null, "m/s"));
        this.dataEncoding = fac.newTextEncoding(",", "\n");
    }

    @Override
    protected void handleMessage(long msgTime, String msgID, String msg) {
        DataBlock dataBlock = null;
        if (msgID.equals("VTG")) {
            String[] tokens = msg.split(",|\\*");
            if (Double.isNaN(((NMEAGpsSensor)this.parentSensor).lastFixUtcTime)) {
                NMEAGpsSensor.log.debug("VTG: No position fix");
                return;
            }
            dataBlock = this.getNewDataBlock();
            dataBlock.setDoubleValue(0, ((NMEAGpsSensor)this.parentSensor).lastFixUtcTime);
            dataBlock.setDoubleValue(1, Double.parseDouble(tokens[1]));
            dataBlock.setDoubleValue(2, this.toMetersPerSecond(tokens[7]));
        } else if (msgID.equals("HDT")) {
            String[] tokens = msg.split(",|\\*");
            if (Double.isNaN(((NMEAGpsSensor)this.parentSensor).lastFixUtcTime)) {
                NMEAGpsSensor.log.debug("HDT: No position fix");
                return;
            }
            dataBlock = this.getNewDataBlock();
            dataBlock.setDoubleValue(0, ((NMEAGpsSensor)this.parentSensor).lastFixUtcTime);
            dataBlock.setDoubleValue(1, Double.parseDouble(tokens[1]));
            dataBlock.setDoubleValue(2, Double.NaN);
        }
        if (dataBlock != null) {
            this.sendOutput(msgTime, dataBlock);
        }
    }

    protected double toMetersPerSecond(String speedKmPerHours) {
        return Double.parseDouble(speedKmPerHours) * 0.2777777777777778;
    }
}

