/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.impl.sensor.nmea.gps;

import net.opengis.swe.v20.DataBlock;
import net.opengis.swe.v20.DataComponent;
import net.opengis.swe.v20.DataEncoding;
import org.sensorhub.api.common.Event;
import org.sensorhub.api.sensor.ISensorDataInterface;
import org.sensorhub.api.sensor.ISensorModule;
import org.sensorhub.api.sensor.SensorDataEvent;
import org.sensorhub.impl.sensor.AbstractSensorOutput;
import org.sensorhub.impl.sensor.nmea.gps.NMEAGpsSensor;

public abstract class NMEAGpsOutput
extends AbstractSensorOutput<NMEAGpsSensor> {
    protected static final String NMEA_SEP_REGEX = ",|\\*";
    protected DataComponent dataStruct;
    protected DataEncoding dataEncoding;
    protected double samplingPeriod;
    protected long lastMsgTime = Long.MIN_VALUE;

    public NMEAGpsOutput(NMEAGpsSensor parentSensor) {
        super((ISensorModule)parentSensor);
    }

    public double getAverageSamplingPeriod() {
        return this.samplingPeriod;
    }

    public DataComponent getRecordDescription() {
        return this.dataStruct;
    }

    public DataEncoding getRecommendedEncoding() {
        return this.dataEncoding;
    }

    protected void sendOutput(long msgTime, DataBlock dataBlock) {
        this.latestRecord = dataBlock;
        this.latestRecordTime = msgTime;
        this.eventHandler.publishEvent((Event)new SensorDataEvent(msgTime, (ISensorDataInterface)this, new DataBlock[]{dataBlock}));
    }

    protected void updateSamplingPeriod(long msgTime) {
        if (this.lastMsgTime != Long.MIN_VALUE) {
            this.samplingPeriod = (double)(msgTime - this.lastMsgTime) / 1000.0;
        }
        this.lastMsgTime = msgTime;
    }

    protected final DataBlock getNewDataBlock() {
        if (this.latestRecord == null) {
            return this.dataStruct.createDataBlock();
        }
        return this.latestRecord.renew();
    }

    protected abstract void handleMessage(long var1, String var3, String var4);
}

