/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.impl.sensor.nmea.gps;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import net.opengis.sensorml.v20.AbstractProcess;
import org.sensorhub.api.comm.CommConfig;
import org.sensorhub.api.comm.ICommProvider;
import org.sensorhub.api.common.SensorHubException;
import org.sensorhub.api.module.ModuleConfig;
import org.sensorhub.api.sensor.ISensorDataInterface;
import org.sensorhub.impl.sensor.AbstractSensorModule;
import org.sensorhub.impl.sensor.nmea.gps.GPSQualityOutput;
import org.sensorhub.impl.sensor.nmea.gps.LLALocationOutput;
import org.sensorhub.impl.sensor.nmea.gps.NEDVelocityOutput;
import org.sensorhub.impl.sensor.nmea.gps.NMEAGpsConfig;
import org.sensorhub.impl.sensor.nmea.gps.NMEAGpsOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NMEAGpsSensor
extends AbstractSensorModule<NMEAGpsConfig> {
    static final Logger log = LoggerFactory.getLogger(NMEAGpsSensor.class);
    public static final String GLL_MSG = "GLL";
    public static final String GGA_MSG = "GGA";
    public static final String GSA_MSG = "GSA";
    public static final String RMC_MSG = "RMC";
    public static final String VTG_MSG = "VTG";
    public static final String ZDA_MSG = "ZDA";
    public static final String HDT_MSG = "HDT";
    ICommProvider<? super CommConfig> commProvider;
    BufferedReader reader;
    volatile boolean started;
    double lastFixUtcTime = Double.NaN;

    public void init(NMEAGpsConfig config) throws SensorHubException {
        NMEAGpsOutput dataInterface;
        super.init((ModuleConfig)config);
        if (config.activeSentences.contains(GLL_MSG) || config.activeSentences.contains(GGA_MSG)) {
            dataInterface = new LLALocationOutput(this);
            this.addOutput((ISensorDataInterface)dataInterface, false);
            ((LLALocationOutput)dataInterface).init();
        }
        if (config.activeSentences.contains(GSA_MSG)) {
            dataInterface = new GPSQualityOutput(this);
            this.addOutput((ISensorDataInterface)dataInterface, false);
            ((GPSQualityOutput)dataInterface).init();
        }
        if (config.activeSentences.contains(VTG_MSG) || config.activeSentences.contains(HDT_MSG)) {
            dataInterface = new NEDVelocityOutput(this);
            this.addOutput((ISensorDataInterface)dataInterface, false);
            ((NEDVelocityOutput)dataInterface).init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSensorDescription() {
        AbstractProcess abstractProcess = this.sensorDescription;
        synchronized (abstractProcess) {
            super.updateSensorDescription();
            this.sensorDescription.setId("GPS_SENSOR");
            this.sensorDescription.setDescription("NMEA 0183 Compatible GNSS Receiver");
        }
    }

    public void start() throws SensorHubException {
        if (this.started) {
            return;
        }
        if (this.commProvider == null) {
            try {
                if (((NMEAGpsConfig)this.config).commSettings == null) {
                    throw new SensorHubException("No communication settings specified");
                }
                this.commProvider = ((NMEAGpsConfig)this.config).commSettings.getProvider();
                this.commProvider.start();
            }
            catch (Exception e) {
                this.commProvider = null;
                throw e;
            }
        }
        try {
            this.reader = new BufferedReader(new InputStreamReader(this.commProvider.getInputStream(), StandardCharsets.US_ASCII));
            log.debug("Connected to NMEA data stream");
        }
        catch (IOException e) {
            throw new RuntimeException("Error while initializing communications ", e);
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (NMEAGpsSensor.this.started) {
                    NMEAGpsSensor.this.pollAndSendMeasurement();
                }
            }
        });
        this.started = true;
        t.start();
    }

    private synchronized void pollAndSendMeasurement() {
        try {
            String msg = this.reader.readLine();
            long msgTime = System.currentTimeMillis();
            if (msg == null) {
                return;
            }
            log.debug("Received message: {}", (Object)msg);
            if (msg.charAt(0) != '$' || !this.validateChecksum(msg)) {
                log.debug("Skipping invalid message");
                return;
            }
            int firstSep = msg.indexOf(44);
            String msgID = msg.substring(3, firstSep);
            for (ISensorDataInterface output : this.getAllOutputs().values()) {
                NMEAGpsOutput nmeaOut = (NMEAGpsOutput)output;
                nmeaOut.handleMessage(msgTime, msgID, msg);
            }
        }
        catch (EOFException e) {
            this.started = false;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while parsing NMEA stream", e);
        }
    }

    protected boolean validateChecksum(String msg) {
        int checkSumIndex = msg.lastIndexOf(42);
        if (checkSumIndex > 0) {
            int msgCheckSum = Integer.parseInt(msg.substring(checkSumIndex + 1), 16);
            int checkSum = 0;
            for (int i = 1; i < checkSumIndex; ++i) {
                checkSum ^= (byte)(msg.charAt(i) & 0xFF);
            }
            if (checkSum != msgCheckSum) {
                log.warn("Wrong checksum {} for message: {}", (Object)checkSum, (Object)msg);
                return false;
            }
        }
        return true;
    }

    public void stop() throws SensorHubException {
        this.started = false;
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.reader = null;
        }
        if (this.commProvider != null) {
            this.commProvider.stop();
            this.commProvider = null;
        }
    }

    public void cleanup() throws SensorHubException {
    }

    public boolean isConnected() {
        return this.commProvider != null;
    }
}

