/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.impl.actuator.pca9685;

import net.opengis.sensorml.v20.AbstractProcess;
import org.sensorhub.api.common.SensorHubException;
import org.sensorhub.api.module.ModuleConfig;
import org.sensorhub.impl.actuator.pca9685.PwmServosConfig;
import org.sensorhub.impl.comm.dio.JdkDioI2CCommProvider;
import org.sensorhub.impl.sensor.AbstractSensorModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PwmServoActuators
extends AbstractSensorModule<PwmServosConfig> {
    static final Logger log = LoggerFactory.getLogger(PwmServoActuators.class);
    JdkDioI2CCommProvider i2cCommProvider;
    volatile boolean started;

    public void init(PwmServosConfig config) throws SensorHubException {
        super.init((ModuleConfig)config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSensorDescription() {
        AbstractProcess abstractProcess = this.sensorDescription;
        synchronized (abstractProcess) {
            super.updateSensorDescription();
            this.sensorDescription.setId("RPI_SERVOS");
            this.sensorDescription.setDescription("Adafruit PCA9685 16-channels PWM servo board");
        }
    }

    public void start() throws SensorHubException {
        if (this.started) {
            return;
        }
        if (this.i2cCommProvider == null) {
            try {
                if (((PwmServosConfig)this.config).commSettings == null) {
                    throw new SensorHubException("No communication settings specified");
                }
                this.i2cCommProvider = (JdkDioI2CCommProvider)((PwmServosConfig)this.config).commSettings.getProvider();
                this.i2cCommProvider.start();
            }
            catch (Exception e) {
                this.i2cCommProvider = null;
                throw e;
            }
        }
    }

    public void stop() throws SensorHubException {
        this.started = false;
        if (this.i2cCommProvider != null) {
            this.i2cCommProvider.stop();
            this.i2cCommProvider = null;
        }
    }

    public void cleanup() throws SensorHubException {
    }

    public boolean isConnected() {
        return this.i2cCommProvider != null;
    }
}

