/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.impl.process.trupulse;

import net.opengis.swe.v20.DataBlock;
import net.opengis.swe.v20.DataComponent;
import net.opengis.swe.v20.DataEncoding;
import net.opengis.swe.v20.DataRecord;
import org.sensorhub.api.common.Event;
import org.sensorhub.api.common.IEventHandler;
import org.sensorhub.api.common.IEventListener;
import org.sensorhub.api.data.DataEvent;
import org.sensorhub.api.data.IStreamingDataInterface;
import org.sensorhub.api.module.IModule;
import org.sensorhub.impl.common.EventBus;
import org.sensorhub.impl.process.trupulse.TargetGeolocProcess;
import org.vast.swe.SWEHelper;

public class TargetGeolocOutput
implements IStreamingDataInterface {
    TargetGeolocProcess parentProcess;
    IEventHandler eventHandler;
    DataComponent outputDef;
    DataEncoding outputEncoding;
    long latestRecordTime = Long.MIN_VALUE;
    DataBlock latestRecord;
    double samplingPeriod = 10.0;

    public TargetGeolocOutput(TargetGeolocProcess parentProcess) {
        this.parentProcess = parentProcess;
        SWEHelper fac = new SWEHelper();
        DataRecord rec = fac.newDataRecord();
        rec.setName(this.getName());
        rec.addField("time", (DataComponent)fac.newTimeStampIsoUTC());
        rec.addField("location", (DataComponent)fac.newLocationVectorLLA(SWEHelper.getPropertyUri((String)"TargetLocation")));
        this.outputDef = rec;
        this.outputEncoding = fac.newTextEncoding();
        String moduleID = parentProcess.getLocalID();
        String topic = this.getName();
        this.eventHandler = EventBus.getInstance().registerProducer(moduleID, topic);
    }

    protected void sendLocation(double time, double lat, double lon, double alt) {
        DataBlock dataBlock;
        if (this.latestRecord == null) {
            dataBlock = this.outputDef.createDataBlock();
        } else {
            dataBlock = this.latestRecord.renew();
            this.samplingPeriod = time - this.latestRecord.getDoubleValue(0);
        }
        dataBlock.setDoubleValue(0, time);
        dataBlock.setDoubleValue(1, lat);
        dataBlock.setDoubleValue(2, lon);
        dataBlock.setDoubleValue(3, alt);
        TargetGeolocProcess.log.debug("Target pos = [{},{},{}]", new Object[]{lat, lon, alt});
        this.latestRecord = dataBlock;
        this.latestRecordTime = System.currentTimeMillis();
        this.eventHandler.publishEvent((Event)new DataEvent(this.latestRecordTime, (IStreamingDataInterface)this, new DataBlock[]{dataBlock}));
    }

    public IModule<?> getParentModule() {
        return this.parentProcess;
    }

    public String getName() {
        return "targetLocation";
    }

    public boolean isEnabled() {
        return true;
    }

    public DataComponent getRecordDescription() {
        return this.outputDef;
    }

    public DataEncoding getRecommendedEncoding() {
        return this.outputEncoding;
    }

    public DataBlock getLatestRecord() {
        return this.latestRecord;
    }

    public long getLatestRecordTime() {
        return this.latestRecordTime;
    }

    public double getAverageSamplingPeriod() {
        return this.samplingPeriod;
    }

    public void registerListener(IEventListener listener) {
        this.eventHandler.registerListener(listener);
    }

    public void unregisterListener(IEventListener listener) {
        this.eventHandler.unregisterListener(listener);
    }
}

