/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.impl.sensor.trupulse;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Writer;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import org.sensorhub.api.comm.ICommProvider;
import org.sensorhub.api.common.SensorHubException;
import org.sensorhub.impl.comm.TCPConfig;
import org.sensorhub.impl.module.AbstractModule;

public class SimulatedTruPulseDataStream
extends AbstractModule<TCPConfig>
implements ICommProvider<TCPConfig> {
    PipedInputStream is;
    Writer writer;
    Timer timer;
    int counter = 0;

    public InputStream getInputStream() throws IOException {
        return this.is;
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    private void sendMeasurement() {
        try {
            float range = 100.0f;
            float az = this.counter % 4 * 90;
            float inc = this.counter / 4 * 10;
            String msg = String.format(Locale.US, "$PLTIT,HV,%.2f,M,%.2f,D,%.2f,D,%.2f,M,*FF\n", Float.valueOf(range), Float.valueOf(az), Float.valueOf(inc), Float.valueOf(range));
            this.writer.write(msg);
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void start() throws SensorHubException {
        try {
            PipedOutputStream os = new PipedOutputStream();
            this.writer = new OutputStreamWriter(os);
            this.is = new PipedInputStream();
            this.is.connect(os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.timer != null) {
            return;
        }
        this.timer = new Timer();
        this.counter = 0;
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                SimulatedTruPulseDataStream.this.sendMeasurement();
                ++SimulatedTruPulseDataStream.this.counter;
            }
        };
        this.timer.scheduleAtFixedRate(task, 0L, 5000L);
    }

    public void stop() throws SensorHubException {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.is = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void cleanup() throws SensorHubException {
    }
}

