/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.impl.sensor.trupulse;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.opengis.swe.v20.DataBlock;
import net.opengis.swe.v20.DataComponent;
import net.opengis.swe.v20.DataEncoding;
import net.opengis.swe.v20.Quantity;
import org.sensorhub.api.comm.ICommProvider;
import org.sensorhub.api.common.Event;
import org.sensorhub.api.sensor.ISensorDataInterface;
import org.sensorhub.api.sensor.ISensorModule;
import org.sensorhub.api.sensor.SensorDataEvent;
import org.sensorhub.impl.sensor.AbstractSensorOutput;
import org.sensorhub.impl.sensor.trupulse.TruPulseSensor;
import org.vast.swe.SWEHelper;

public class TruPulseOutput
extends AbstractSensorOutput<TruPulseSensor> {
    private static String MSG_PREFIX = "$PLTIT";
    private static String MSG_TYPE_HV = "HV";
    private static double FEET_TO_METERS = 0.30480061;
    private static double YARDS_TO_METERS = 0.9144;
    DataComponent laserData;
    DataEncoding dataEncoding;
    BufferedReader msgReader;
    boolean sendData;

    public TruPulseOutput(TruPulseSensor parentSensor) {
        super((ISensorModule)parentSensor);
    }

    public String getName() {
        return "rangeData";
    }

    public void init() {
        SWEHelper fac = new SWEHelper();
        this.laserData = fac.newDataRecord(5);
        this.laserData.setName(this.getName());
        this.laserData.setDefinition("http://sensorml.com/ont/swe/property/LaserRangeData");
        this.laserData.addComponent("time", (DataComponent)fac.newTimeStampIsoUTC());
        this.laserData.addComponent("horizDistance", (DataComponent)fac.newQuantity(SWEHelper.getPropertyUri((String)"HorizontalDistance"), "Horizontal Distance", null, "m"));
        this.laserData.addComponent("slopeDistance", (DataComponent)fac.newQuantity(SWEHelper.getPropertyUri((String)"LineOfSightDistance"), "Line-of-Sight Distance", null, "m"));
        Quantity q = fac.newQuantity(SWEHelper.getPropertyUri((String)"TrueHeading"), "True Heading", null, "deg");
        q.setReferenceFrame("http://sensorml.com/ont/swe/property/NED");
        q.setAxisID("z");
        this.laserData.addComponent("azimuth", (DataComponent)q);
        q = fac.newQuantity(SWEHelper.getPropertyUri((String)"Inclination"), "Inclination", null, "deg");
        q.setReferenceFrame("http://sensorml.com/ont/swe/property/NED");
        q.setAxisID("y");
        this.laserData.addComponent("inclination", (DataComponent)q);
        this.dataEncoding = fac.newTextEncoding(",", "\n");
    }

    private void pollAndSendMeasurement() {
        long msgTime = System.currentTimeMillis();
        double hd = Double.NaN;
        double incl = Double.NaN;
        double az = Double.NaN;
        double sd = Double.NaN;
        try {
            boolean gotHvMsg = false;
            while (!gotHvMsg) {
                String line = this.msgReader.readLine();
                TruPulseSensor.log.debug("Message received: {}", (Object)line);
                String[] tokens = line.split(",");
                String val = tokens[0];
                if (!val.equals(MSG_PREFIX)) {
                    TruPulseSensor.log.warn("Message initial token does NOT equal expected string {}", (Object)MSG_PREFIX);
                    continue;
                }
                val = tokens[1];
                if (!val.equals(MSG_TYPE_HV)) {
                    TruPulseSensor.log.warn("Unsupported message type {}", (Object)val);
                    continue;
                }
                val = tokens[2];
                String unit = tokens[3];
                if (val.length() > 0 && unit.length() > 0) {
                    hd = Double.parseDouble(val);
                    hd = this.convert(hd, unit);
                }
                val = tokens[4];
                unit = tokens[5];
                if (val.length() > 0 && unit.length() > 0) {
                    az = Double.parseDouble(val);
                }
                val = tokens[6];
                unit = tokens[7];
                if (val.length() > 0 && unit.length() > 0) {
                    incl = Double.parseDouble(val);
                }
                val = tokens[8];
                unit = tokens[9];
                if (val.length() > 0 && unit.length() > 0) {
                    sd = Double.parseDouble(val);
                    sd = this.convert(hd, unit);
                }
                gotHvMsg = true;
            }
        }
        catch (IOException e) {
            if (this.sendData) {
                TruPulseSensor.log.error("Unable to parse TruPulse message", (Throwable)e);
            }
            return;
        }
        DataBlock dataBlock = this.latestRecord == null ? this.laserData.createDataBlock() : this.latestRecord.renew();
        dataBlock.setDoubleValue(0, (double)msgTime / 1000.0);
        dataBlock.setDoubleValue(1, hd);
        dataBlock.setDoubleValue(2, sd);
        dataBlock.setDoubleValue(3, az);
        dataBlock.setDoubleValue(4, incl);
        this.latestRecord = dataBlock;
        this.latestRecordTime = msgTime;
        this.eventHandler.publishEvent((Event)new SensorDataEvent(this.latestRecordTime, (ISensorDataInterface)this, new DataBlock[]{dataBlock}));
    }

    protected double convert(double val, String unit) {
        if (unit.equals("F")) {
            return val * FEET_TO_METERS;
        }
        if (unit.equals("Y")) {
            return val * YARDS_TO_METERS;
        }
        return val;
    }

    protected void start(ICommProvider<?> commProvider) {
        if (this.sendData) {
            return;
        }
        this.sendData = true;
        try {
            this.msgReader = new BufferedReader(new InputStreamReader(commProvider.getInputStream()));
            TruPulseSensor.log.info("Connected to TruPulse data stream");
        }
        catch (IOException e) {
            throw new RuntimeException("Error while initializing communications ", e);
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (TruPulseOutput.this.sendData) {
                    TruPulseOutput.this.pollAndSendMeasurement();
                }
            }
        });
        t.start();
    }

    protected void stop() {
        this.sendData = false;
        if (this.msgReader != null) {
            try {
                this.msgReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.msgReader = null;
        }
    }

    public double getAverageSamplingPeriod() {
        return 1200.0;
    }

    public DataComponent getRecordDescription() {
        return this.laserData;
    }

    public DataEncoding getRecommendedEncoding() {
        return this.dataEncoding;
    }
}

