/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.impl.sensor.trupulse;

import net.opengis.sensorml.v20.AbstractProcess;
import org.sensorhub.api.comm.CommConfig;
import org.sensorhub.api.comm.ICommProvider;
import org.sensorhub.api.common.SensorHubException;
import org.sensorhub.api.module.ModuleConfig;
import org.sensorhub.api.sensor.ISensorDataInterface;
import org.sensorhub.impl.sensor.AbstractSensorModule;
import org.sensorhub.impl.sensor.trupulse.TruPulseConfig;
import org.sensorhub.impl.sensor.trupulse.TruPulseOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TruPulseSensor
extends AbstractSensorModule<TruPulseConfig> {
    static final Logger log = LoggerFactory.getLogger(TruPulseSensor.class);
    ICommProvider<? super CommConfig> commProvider;
    TruPulseOutput dataInterface;

    public void init(TruPulseConfig config) throws SensorHubException {
        super.init((ModuleConfig)config);
        this.dataInterface = new TruPulseOutput(this);
        this.addOutput((ISensorDataInterface)this.dataInterface, false);
        this.dataInterface.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSensorDescription() {
        AbstractProcess abstractProcess = this.sensorDescription;
        synchronized (abstractProcess) {
            super.updateSensorDescription();
            this.sensorDescription.setId("TruPulse");
            this.sensorDescription.setUniqueIdentifier("urn:test:sensors:trupulse360");
            this.sensorDescription.setDescription("Laser RangeFinder for determining distance, inclination, and azimuth");
        }
    }

    public void start() throws SensorHubException {
        if (this.commProvider == null) {
            try {
                if (((TruPulseConfig)this.config).commSettings == null) {
                    throw new SensorHubException("No communication settings specified");
                }
                this.commProvider = ((TruPulseConfig)this.config).commSettings.getProvider();
                this.commProvider.start();
            }
            catch (Exception e) {
                this.commProvider = null;
                throw e;
            }
        }
        this.dataInterface.start(this.commProvider);
    }

    public void stop() throws SensorHubException {
        if (this.dataInterface != null) {
            this.dataInterface.stop();
        }
        if (this.commProvider != null) {
            this.commProvider.stop();
            this.commProvider = null;
        }
    }

    public void cleanup() throws SensorHubException {
    }

    public boolean isConnected() {
        return this.commProvider != null;
    }
}

