/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.impl.process.trupulse;

import java.util.Arrays;
import net.opengis.swe.v20.DataBlock;
import net.opengis.swe.v20.DataComponent;
import net.opengis.swe.v20.DataRecord;
import org.sensorhub.api.common.Event;
import org.sensorhub.api.common.IEventListener;
import org.sensorhub.api.common.SensorHubException;
import org.sensorhub.api.data.DataEvent;
import org.sensorhub.api.data.IStreamingDataInterface;
import org.sensorhub.api.module.ModuleConfig;
import org.sensorhub.api.processing.DataSourceConfig;
import org.sensorhub.api.processing.ProcessException;
import org.sensorhub.api.sensor.ISensorDataInterface;
import org.sensorhub.api.sensor.SensorDataEvent;
import org.sensorhub.impl.process.geoloc.GeoTransforms;
import org.sensorhub.impl.process.geoloc.NadirPointing;
import org.sensorhub.impl.process.trupulse.TargetGeolocConfig;
import org.sensorhub.impl.process.trupulse.TargetGeolocOutput;
import org.sensorhub.impl.processing.AbstractStreamProcess;
import org.sensorhub.impl.sensor.trupulse.TruPulseConfig;
import org.sensorhub.impl.sensor.trupulse.TruPulseOutput;
import org.sensorhub.impl.sensor.trupulse.TruPulseSensor;
import org.sensorhub.vecmath.Mat3d;
import org.sensorhub.vecmath.Vect3d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vast.process.DataQueue;
import org.vast.swe.SWEHelper;

public class TargetGeolocProcess
extends AbstractStreamProcess<TargetGeolocConfig> {
    protected static final Logger log = LoggerFactory.getLogger(TargetGeolocProcess.class);
    protected TargetGeolocOutput targetLocOutput;
    protected GeoTransforms geoConv = new GeoTransforms();
    protected NadirPointing nadirPointing = new NadirPointing();
    protected boolean lastSensorPosSet = false;
    protected Vect3d lastSensorPosEcef = new Vect3d();
    protected Vect3d lla = new Vect3d();
    protected Mat3d ecefRot = new Mat3d();
    protected DataRecord sensorLocInput;
    protected DataComponent rangeMeasInput;
    protected DataQueue sensorLocQueue;
    protected DataQueue rangeMeasQueue;

    public void init(TargetGeolocConfig config) throws SensorHubException {
        this.config = config;
        if (config.fixedPosLLA != null) {
            double[] pos = config.fixedPosLLA;
            try {
                this.lla.set(Math.toRadians(pos[1]), Math.toRadians(pos[0]), pos[2]);
                this.geoConv.LLAtoECEF(this.lla, this.lastSensorPosEcef);
                this.lastSensorPosSet = true;
            }
            catch (Exception e) {
                throw new SensorHubException("Invalid sensor position: " + Arrays.toString(pos));
            }
        }
        SWEHelper fac = new SWEHelper();
        this.sensorLocInput = fac.newDataRecord();
        this.sensorLocInput.setName("sensorLocation");
        this.sensorLocInput.addField("time", (DataComponent)fac.newTimeStampIsoUTC());
        this.sensorLocInput.addField("loc", (DataComponent)fac.newLocationVectorLLA("http://www.opengis.net/def/property/OGC/0/SensorLocation"));
        this.inputs.put(this.sensorLocInput.getName(), this.sensorLocInput);
        TruPulseOutput sensorOutput = new TruPulseOutput(null);
        sensorOutput.init();
        this.rangeMeasInput = sensorOutput.getRecordDescription();
        this.inputs.put(this.rangeMeasInput.getName(), this.rangeMeasInput);
        this.targetLocOutput = new TargetGeolocOutput(this);
        this.addOutput(this.targetLocOutput);
        super.init((ModuleConfig)config);
    }

    protected void connectInput(String inputName, String dataPath, DataQueue inputQueue) throws Exception {
        super.connectInput(inputName, dataPath, inputQueue);
        if (inputName.equals(this.sensorLocInput.getName())) {
            this.sensorLocQueue = inputQueue;
        } else if (inputName.equals(this.rangeMeasInput.getName())) {
            this.rangeMeasQueue = inputQueue;
        }
    }

    protected void process(DataEvent lastEvent) throws ProcessException {
        try {
            if (this.sensorLocQueue != null && this.sensorLocQueue.isDataAvailable()) {
                DataBlock dataBlk = this.sensorLocQueue.get();
                double lat = dataBlk.getDoubleValue(1);
                double lon = dataBlk.getDoubleValue(2);
                double alt = dataBlk.getDoubleValue(3);
                log.trace("Last GPS pos = [{},{},{}]", new Object[]{lat, lon, alt});
                this.lla.y = Math.toRadians(lat);
                this.lla.x = Math.toRadians(lon);
                this.lla.z = alt;
                this.geoConv.LLAtoECEF(this.lla, this.lastSensorPosEcef);
                this.lastSensorPosSet = true;
            } else if (this.lastSensorPosSet && this.rangeMeasQueue.isDataAvailable()) {
                DataBlock dataBlk = this.rangeMeasQueue.get();
                double time = dataBlk.getDoubleValue(0);
                double range = dataBlk.getDoubleValue(2);
                double az = dataBlk.getDoubleValue(3);
                double inc = dataBlk.getDoubleValue(4);
                log.debug("TruPulse meas: range={}, az={}, inc={}", new Object[]{range, az, inc});
                if (Double.isNaN(range)) {
                    return;
                }
                Vect3d los = new Vect3d(0.0, range, 0.0);
                los.rotateX(Math.toRadians(inc));
                los.rotateZ(Math.toRadians(-az));
                this.nadirPointing.getRotationMatrixENUToECEF(this.lastSensorPosEcef, this.ecefRot);
                los.rotate(this.ecefRot);
                los.add(this.lastSensorPosEcef);
                this.geoConv.ECEFtoLLA(los, this.lla);
                this.targetLocOutput.sendLocation(time, Math.toDegrees(this.lla.y), Math.toDegrees(this.lla.x), this.lla.z);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isPauseSupported() {
        return false;
    }

    public boolean isCompatibleDataSource(DataSourceConfig dataSource) {
        return true;
    }

    public static void main(String[] args) throws Exception {
        TargetGeolocProcess p = new TargetGeolocProcess();
        TargetGeolocConfig processConf = new TargetGeolocConfig();
        processConf.fixedPosLLA = new double[]{45.0, 0.0, 0.0};
        p.init(processConf);
        p.sensorLocQueue = new DataQueue();
        p.rangeMeasQueue = new DataQueue();
        TruPulseSensor sensor = new TruPulseSensor();
        TruPulseConfig sensorConf = new TruPulseConfig();
        sensor.init(sensorConf);
        ISensorDataInterface sensorOutput = (ISensorDataInterface)sensor.getAllOutputs().values().iterator().next();
        DataComponent outputDef = sensorOutput.getRecordDescription();
        IStreamingDataInterface processOutput = (IStreamingDataInterface)p.getAllOutputs().values().iterator().next();
        IEventListener l = new IEventListener(){

            public void handleEvent(Event<?> e) {
                DataBlock data = ((DataEvent)e).getRecords()[0];
                double lat = data.getDoubleValue(1);
                double lon = data.getDoubleValue(2);
                double alt = data.getDoubleValue(3);
                System.out.println("Target Loc = " + lat + "," + lon + "," + alt);
            }
        };
        processOutput.registerListener(l);
        DataBlock dataBlk = outputDef.createDataBlock();
        long now = System.currentTimeMillis();
        double range = 1000.0;
        double az = 90.0;
        double inc = 45.0;
        dataBlk.setDoubleValue(0, (double)now / 1000.0);
        dataBlk.setDoubleValue(2, range);
        dataBlk.setDoubleValue(3, az);
        dataBlk.setDoubleValue(4, inc);
        p.rangeMeasQueue.add(dataBlk);
        p.process((DataEvent)new SensorDataEvent(now, sensorOutput, new DataBlock[]{dataBlk}));
    }
}

