/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows;

import org.vast.ows.AbstractResponseReader;
import org.vast.ows.OWSException;
import org.vast.ows.OWSServiceCapabilities;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractCapabilitiesReader
extends AbstractResponseReader<OWSServiceCapabilities> {
    protected static final String xmlError = "Error while parsing capabilities document XML";

    @Override
    public abstract OWSServiceCapabilities readXMLResponse(DOMHelper var1, Element var2) throws OWSException;

    protected abstract void readContents(DOMHelper var1, Element var2, OWSServiceCapabilities var3) throws OWSException;

    protected void readOperationsMetadata(DOMHelper dom, Element capabilitiesElt, OWSServiceCapabilities serviceCaps) throws OWSException {
        NodeList operationList = dom.getElements(capabilitiesElt, "OperationsMetadata/Operation");
        for (int i = 0; i < operationList.getLength(); ++i) {
            String postServer;
            Element operationElt = (Element)operationList.item(i);
            String name = dom.getAttributeValue(operationElt, "name");
            String getServer = dom.getAttributeValue(operationElt, "DCP/HTTP/Get/href");
            if (getServer != null) {
                serviceCaps.getGetServers().put(name, getServer);
            }
            if ((postServer = dom.getAttributeValue(operationElt, "DCP/HTTP/Post/href")) == null) continue;
            serviceCaps.getPostServers().put(name, postServer);
        }
    }
}

