/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows;

import java.io.InputStream;
import java.util.Map;
import javax.xml.namespace.QName;
import org.vast.ows.OWSCommonUtils;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.OWSRequest;
import org.vast.ows.OWSRequestReader;
import org.vast.xml.DOMHelper;
import org.vast.xml.DOMHelperException;
import org.w3c.dom.Element;

public abstract class AbstractRequestReader<RequestType extends OWSRequest>
extends OWSCommonUtils
implements OWSRequestReader<RequestType> {
    protected static final String versionRegex = "^[0-9]+\\.[0-9]+(\\.[0-9]+)?$";
    protected static final String noKVP = "KVP request not supported in ";
    protected static final String noXML = "XML request not supported in ";
    protected String owsVersion = "1.0";

    @Override
    public abstract RequestType readURLParameters(Map<String, String> var1) throws OWSException;

    @Override
    public abstract RequestType readXMLQuery(DOMHelper var1, Element var2) throws OWSException;

    public static void readCommonXML(DOMHelper dom, Element requestElt, OWSRequest request) {
        request.setOperation(requestElt.getLocalName());
        request.setService(dom.getAttributeValue(requestElt, "service"));
        request.setVersion(dom.getAttributeValue(requestElt, "version"));
    }

    @Override
    public RequestType readURLQuery(String queryString) throws OWSException {
        Map<String, String> queryParams = this.parseQueryParameters(queryString);
        return this.readURLParameters(queryParams);
    }

    public RequestType readXMLQuery(InputStream input) throws OWSException {
        try {
            DOMHelper dom = new DOMHelper(input, false);
            return this.readXMLQuery(dom, dom.getBaseElement());
        }
        catch (DOMHelperException e) {
            throw new OWSException((Exception)((Object)e));
        }
    }

    public void readCommonQueryArguments(Map<String, String> queryParameters, OWSRequest request) throws OWSException {
        String val = queryParameters.remove("service");
        if (val != null) {
            request.setService(val);
        }
        if ((val = queryParameters.remove("version")) != null) {
            request.setVersion(val);
        }
        if ((val = queryParameters.remove("request")) != null) {
            request.setOperation(val);
        }
    }

    public void addKVPExtension(String argName, String argValue, OWSRequest request) throws OWSException {
        request.getExtensions().put(new QName(argName), argValue);
    }

    public void checkParameters(OWSRequest request, OWSExceptionReport report) throws OWSException {
        AbstractRequestReader.checkParameters(request, report, null);
    }

    public static void checkParameters(OWSRequest request, OWSExceptionReport report, String serviceType) throws OWSException {
        String reqService;
        if (serviceType != null && serviceType.equals("WMS")) {
            request.setService("WMS");
        }
        if (request.getService() == null) {
            report.add(new OWSException("MissingParameterValue", "SERVICE"));
        } else if (serviceType != null && !(reqService = request.getService()).equalsIgnoreCase(serviceType)) {
            report.add(new OWSException("InvalidParameterValue", "SERVICE", reqService, ""));
        }
        if (request.getVersion() == null) {
            if (request.getOperation() != null && !request.getOperation().equalsIgnoreCase("GetCapabilities")) {
                report.add(new OWSException("MissingParameterValue", "VERSION"));
            }
        } else if (!request.getVersion().matches(versionRegex)) {
            OWSException ex = new OWSException("InvalidParameterValue", "VERSION");
            ex.setBadValue(request.getVersion());
            report.add(ex);
        }
        if (request.getOperation() == null) {
            report.add(new OWSException("MissingParameterValue", "REQUEST"));
        }
    }
}

