/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Map;
import javax.xml.namespace.QName;
import org.vast.ows.OWSException;
import org.vast.ows.OWSRequest;
import org.vast.ows.OWSRequestWriter;
import org.vast.util.Bbox;
import org.vast.util.DateTimeFormat;
import org.vast.util.TimeExtent;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractRequestWriter<RequestType extends OWSRequest>
implements OWSRequestWriter<RequestType> {
    public static final String ioError = "IO error while writing XML request to stream";
    protected static final String noKVP = "KVP request not supported in ";
    protected static final String noXML = "XML request not supported in ";
    protected DateTimeFormat timeFormat = new DateTimeFormat();

    public Map<String, String> buildURLParameters(RequestType request) throws OWSException {
        throw new RuntimeException("buildURLParameters() method not implemented");
    }

    @Override
    public abstract Element buildXMLQuery(DOMHelper var1, RequestType var2) throws OWSException;

    @Override
    public String buildURLQuery(RequestType request) throws OWSException {
        Map<String, String> urlParams = this.buildURLParameters(request);
        StringBuffer urlBuff = new StringBuffer(((OWSRequest)request).getGetServer());
        for (Map.Entry<String, String> arg : urlParams.entrySet()) {
            urlBuff.append(arg.getKey());
            urlBuff.append('=');
            urlBuff.append(this.urlEncode(arg.getValue()));
            urlBuff.append('&');
        }
        urlBuff.deleteCharAt(urlBuff.length() - 1);
        return urlBuff.toString();
    }

    public void writeXMLQuery(OutputStream os, RequestType request) throws OWSException {
        try {
            DOMHelper dom = new DOMHelper();
            Element requestElt = this.buildXMLQuery(dom, request);
            dom.serialize((Node)requestElt, os, true);
        }
        catch (IOException e) {
            throw new OWSException(ioError, e);
        }
    }

    protected String urlEncode(String urlParam) {
        try {
            urlParam = URLEncoder.encode(urlParam, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return urlParam;
    }

    protected void writeTimeArgument(StringBuilder buffer, TimeExtent time) {
        if (time.isTimeInstant()) {
            if (time.isBaseAtNow()) {
                buffer.append("now");
            } else {
                buffer.append(this.timeFormat.formatIso(time.getBaseTime(), 0));
            }
        } else {
            if (time.isBeginNow()) {
                buffer.append("now");
            } else {
                buffer.append(this.timeFormat.formatIso(time.getStartTime(), 0));
            }
            buffer.append('/');
            if (time.isEndNow()) {
                buffer.append("now");
            } else {
                buffer.append(this.timeFormat.formatIso(time.getStopTime(), 0));
            }
            if (time.getTimeStep() > 0.0) {
                buffer.append('/');
                buffer.append(this.timeFormat.formatIsoPeriod(time.getTimeStep()));
            }
        }
    }

    protected void writeBboxArgument(StringBuilder buffer, Bbox bbox) {
        this.writeBboxArgument(buffer, bbox, false);
    }

    protected void writeBboxArgument(StringBuilder buffer, Bbox bbox, boolean writeCrs) {
        buffer.append(bbox.getMinX());
        buffer.append("," + bbox.getMinY());
        buffer.append("," + bbox.getMaxX());
        buffer.append("," + bbox.getMaxY());
        if (bbox.getCrs() != null) {
            buffer.append(',').append(bbox.getCrs());
        }
    }

    protected String getGmlBboxCoordsList(Bbox bbox) {
        StringBuffer buff = new StringBuffer();
        buff.append(bbox.getMinX());
        buff.append("," + bbox.getMinY());
        buff.append(" " + bbox.getMaxX());
        buff.append("," + bbox.getMaxY());
        return buff.toString();
    }

    protected void addCommonXML(DOMHelper dom, Element requestElt, OWSRequest request) {
        requestElt.setAttribute("service", request.getService());
        requestElt.setAttribute("version", request.getVersion());
    }

    protected void addCommonArgs(Map<String, String> urlParams, OWSRequest request) {
        urlParams.put("service", request.getService());
        urlParams.put("version", request.getVersion());
        urlParams.put("request", request.getOperation());
    }

    protected void addCommonArgs(StringBuilder buf, OWSRequest request) {
        buf.append("service=");
        buf.append(request.getService());
        buf.append("&version=");
        buf.append(request.getVersion());
        buf.append("&request=");
        buf.append(request.getOperation());
    }

    protected void writeKVPExtensions(StringBuilder urlBuff, OWSRequest request) {
        for (Map.Entry<QName, Object> extension : request.getExtensions().entrySet()) {
            String paramName = extension.getKey().getLocalPart();
            Object extValue = extension.getValue();
            String paramValue = this.getExtensionKvpValue(extValue);
            if (paramValue == null) continue;
            urlBuff.append('&');
            urlBuff.append(paramName);
            urlBuff.append('=');
            urlBuff.append(paramValue);
        }
    }

    protected void writeKvpExtensions(Map<String, String> urlParams, OWSRequest request) {
        for (Map.Entry<QName, Object> extension : request.getExtensions().entrySet()) {
            String paramName = extension.getKey().getLocalPart();
            Object extValue = extension.getValue();
            String paramValue = this.getExtensionKvpValue(extValue);
            if (paramValue == null) continue;
            urlParams.put(paramName, paramValue);
        }
    }

    protected String getExtensionKvpValue(Object extValue) {
        if (extValue instanceof String || extValue instanceof Number || extValue instanceof Boolean) {
            return extValue.toString();
        }
        if (extValue instanceof Date) {
            return this.timeFormat.formatIso((double)((Date)extValue).getTime() / 1000.0, 0);
        }
        if (extValue instanceof TimeExtent) {
            StringBuilder buf = new StringBuilder();
            this.writeTimeArgument(buf, (TimeExtent)extValue);
            return buf.toString();
        }
        return null;
    }
}

