/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows;

import java.io.IOException;
import java.io.OutputStream;
import org.vast.ows.OWSException;
import org.vast.ows.OWSResponse;
import org.vast.ows.OWSResponseWriter;
import org.vast.util.DateTimeFormat;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractResponseWriter<ResponseType extends OWSResponse>
implements OWSResponseWriter<ResponseType> {
    public static final String xmlError = "Error while generating XML for ";
    public static final String ioError = "IO error while writing XML response to stream";
    public static final String unsupportedVersion = "No support for version ";
    protected DateTimeFormat timeFormat = new DateTimeFormat();

    @Override
    public abstract Element buildXMLResponse(DOMHelper var1, ResponseType var2, String var3) throws OWSException;

    @Override
    public Element buildXMLResponse(DOMHelper dom, ResponseType response) throws OWSException {
        try {
            return this.buildXMLResponse(dom, response, ((OWSResponse)response).getVersion());
        }
        catch (OWSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(xmlError + response.getClass().getName(), e);
        }
    }

    @Override
    public void writeXMLResponse(OutputStream os, ResponseType response, String version) throws OWSException {
        try {
            DOMHelper dom = new DOMHelper();
            Element responseElt = this.buildXMLResponse(dom, response, version);
            dom.serialize((Node)responseElt, os, true);
        }
        catch (IOException e) {
            throw new OWSException(ioError, e);
        }
    }

    @Override
    public void writeXMLResponse(OutputStream os, ResponseType response) throws OWSException {
        this.writeXMLResponse(os, response, ((OWSResponse)response).getVersion());
    }
}

