/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows;

import java.util.Map;
import org.vast.ows.AbstractRequestReader;
import org.vast.ows.GetCapabilitiesRequest;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GetCapabilitiesReader
extends AbstractRequestReader<GetCapabilitiesRequest> {
    protected String service;

    public GetCapabilitiesReader() {
    }

    public GetCapabilitiesReader(String service) {
        this.service = service;
    }

    @Override
    public GetCapabilitiesRequest readURLParameters(Map<String, String> queryParameters) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport();
        GetCapabilitiesRequest request = new GetCapabilitiesRequest();
        for (Map.Entry<String, String> item : queryParameters.entrySet()) {
            String argName = item.getKey();
            String argValue = item.getValue();
            if (argName.equalsIgnoreCase("service")) {
                request.setService(argValue);
                continue;
            }
            if (argName.equalsIgnoreCase("version")) {
                request.setVersion(argValue);
                continue;
            }
            if (argName.equalsIgnoreCase("acceptVersions")) {
                request.getAcceptedVersions().clear();
                for (String version : argValue.split(",")) {
                    request.getAcceptedVersions().add(version);
                }
                continue;
            }
            if (argName.equalsIgnoreCase("request")) {
                request.setOperation(argValue);
                continue;
            }
            if (!argName.equalsIgnoreCase("section")) continue;
            request.setSection(argValue);
        }
        this.checkParameters(request, report, this.service);
        report.process();
        return request;
    }

    @Override
    public GetCapabilitiesRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport();
        GetCapabilitiesRequest request = new GetCapabilitiesRequest();
        GetCapabilitiesReader.readCommonXML(dom, requestElt, request);
        request.setSection(dom.getElementValue(requestElt, "section"));
        NodeList versionList = dom.getElements(requestElt, "acceptVersions");
        for (int i = 0; i < versionList.getLength(); ++i) {
            String val = dom.getElementValue((Element)versionList.item(i));
            request.getAcceptedVersions().add(val);
        }
        this.checkParameters(request, report, this.service);
        report.process();
        return request;
    }

    protected void checkParameters(GetCapabilitiesRequest request, OWSExceptionReport report, String serviceType) throws OWSException {
        String reqService;
        if (request.getService() == null) {
            report.add(new OWSException("MissingParameterValue", "service"));
        } else if (serviceType != null && !(reqService = request.getService()).equalsIgnoreCase(serviceType)) {
            report.add(new OWSException("InvalidParameterValue", "SERVICE", reqService, ""));
        }
        if (request.getVersion() != null && !request.getVersion().matches("^[0-9]+\\.[0-9]+(\\.[0-9]+)?$")) {
            OWSException ex = new OWSException("InvalidParameterValue", "VERSION");
            ex.setBadValue(request.getVersion());
            report.add(ex);
        }
        for (String version : request.getAcceptedVersions()) {
            if (version.matches("^[0-9]+\\.[0-9]+(\\.[0-9]+)?$")) continue;
            OWSException ex = new OWSException("InvalidParameterValue", "VERSION");
            ex.setBadValue(request.getVersion());
            report.add(ex);
        }
        if (request.getOperation() == null) {
            report.add(new OWSException("MissingParameterValue", "REQUEST"));
        }
    }
}

