/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows;

import org.vast.ogc.OGCRegistry;
import org.vast.ows.AbstractRequestWriter;
import org.vast.ows.GetCapabilitiesRequest;
import org.vast.ows.OWSException;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class GetCapabilitiesWriter
extends AbstractRequestWriter<GetCapabilitiesRequest> {
    @Override
    public String buildURLQuery(GetCapabilitiesRequest request) throws OWSException {
        StringBuffer urlBuff = new StringBuffer(request.getGetServer());
        urlBuff.append("service=" + request.getService());
        if (request.getAcceptedVersions().isEmpty()) {
            if (request.getVersion() != null) {
                urlBuff.append("&version=" + request.getVersion());
            }
        } else {
            urlBuff.append("&acceptVersions=");
            for (String version : request.getAcceptedVersions()) {
                urlBuff.append(version).append(',');
            }
            urlBuff.deleteCharAt(urlBuff.length() - 1);
        }
        urlBuff.append("&request=" + request.getOperation());
        if (request.getSection() != null) {
            urlBuff.append("&section=" + request.getSection());
        }
        return urlBuff.toString();
    }

    @Override
    public Element buildXMLQuery(DOMHelper dom, GetCapabilitiesRequest request) throws OWSException {
        String nsUri = OGCRegistry.getNamespaceURI((String)request.getService(), (String)request.getVersion());
        dom.addUserPrefix("_NIL_", nsUri);
        Element rootElt = dom.createElement(request.getOperation());
        dom.setAttributeValue(rootElt, "service", request.getService());
        if (request.getAcceptedVersions().isEmpty()) {
            if (request.getVersion() != null) {
                dom.setAttributeValue(rootElt, "version", request.getVersion());
            }
        } else {
            for (String version : request.getAcceptedVersions()) {
                dom.setElementValue(rootElt, "+AcceptVersions", version);
            }
        }
        if (request.getSection() != null) {
            dom.setElementValue(rootElt, "Sections", request.getSection());
        }
        return rootElt;
    }
}

