/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows;

import org.vast.ows.AbstractCapabilitiesReader;
import org.vast.ows.OWSException;
import org.vast.ows.OWSIdentification;
import org.vast.ows.OWSServiceCapabilities;
import org.vast.util.ResponsibleParty;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class OWSCapabilitiesReaderV0
extends AbstractCapabilitiesReader {
    @Override
    public OWSServiceCapabilities readXMLResponse(DOMHelper dom, Element capabilitiesElt) throws OWSException {
        return this.readOWSCapabilities(dom, capabilitiesElt, new OWSServiceCapabilities());
    }

    protected OWSServiceCapabilities readOWSCapabilities(DOMHelper dom, Element capabilitiesElt, OWSServiceCapabilities serviceCaps) throws OWSException {
        String version = dom.getAttributeValue(capabilitiesElt, "version");
        serviceCaps.setVersion(version);
        String updateSequence = dom.getAttributeValue(capabilitiesElt, "updateSequence");
        serviceCaps.setUpdateSequence(updateSequence);
        Element serviceElt = dom.getElement(capabilitiesElt, "Service");
        this.readIdentification(serviceCaps.getIdentification(), dom, serviceElt);
        String fees = dom.getElementValue(serviceElt, "fees");
        serviceCaps.setFees(fees);
        String constraints = dom.getElementValue(serviceElt, "accessConstraints");
        serviceCaps.setAccessConstraints(constraints);
        Element respPartyElt = dom.getElement(serviceElt, "responsibleParty");
        this.readResponsibleParty(dom, respPartyElt, serviceCaps);
        this.readOperationsMetadata(dom, capabilitiesElt, serviceCaps);
        this.readContents(dom, capabilitiesElt, serviceCaps);
        return serviceCaps;
    }

    @Override
    protected void readOperationsMetadata(DOMHelper dom, Element capabilitiesElt, OWSServiceCapabilities serviceCaps) {
        NodeList opElts = dom.getElements(capabilitiesElt, "Capability/Request/*");
        int numElts = opElts.getLength();
        for (int i = 0; i < numElts; ++i) {
            Element opElt = (Element)opElts.item(i);
            String opName = opElt.getLocalName();
            String getUrl = dom.getAttributeValue(opElt, "DCPType/HTTP/Get/OnlineResource/@href");
            String postUrl = dom.getAttributeValue(opElt, "DCPType/HTTP/Post/OnlineResource/@href");
            if (getUrl != null) {
                serviceCaps.getGetServers().put(opName, getUrl);
            }
            if (postUrl == null) continue;
            serviceCaps.getPostServers().put(opName, postUrl);
        }
    }

    protected void readIdentification(OWSIdentification idObject, DOMHelper dom, Element parentElt) {
        String desc = dom.getElementValue(parentElt, "description");
        idObject.setDescription(desc);
        String name = dom.getElementValue(parentElt, "name");
        idObject.setIdentifier(name);
        String serviceTitle = dom.getElementValue(parentElt, "label");
        idObject.setTitle(serviceTitle);
        NodeList keywordElts = dom.getElements(parentElt, "keywords/keyword");
        int numElts = keywordElts.getLength();
        for (int i = 0; i < numElts; ++i) {
            Element keywordElt = (Element)keywordElts.item(i);
            String keyword = dom.getElementValue(keywordElt);
            idObject.getKeywords().add(keyword);
        }
    }

    protected void readResponsibleParty(DOMHelper dom, Element respPartyElt, OWSServiceCapabilities serviceCaps) {
        ResponsibleParty provider = serviceCaps.getServiceProvider();
        String text = dom.getElementValue(respPartyElt, "individualName");
        provider.setIndividualName(text);
        text = dom.getElementValue(respPartyElt, "organisationName");
        provider.setOrganizationName(text);
        text = dom.getElementValue(respPartyElt, "positionName");
        provider.setPositionName(text);
        Element contactInfoElt = dom.getElement(respPartyElt, "contactInfo");
        text = dom.getElementValue(contactInfoElt, "phone/voice");
        provider.setVoiceNumber(text);
        text = dom.getElementValue(contactInfoElt, "phone/facsimile");
        provider.setFaxNumber(text);
        Element addressElt = dom.getElement(contactInfoElt, "address");
        text = dom.getElementValue(addressElt, "deliveryPoint");
        provider.setDeliveryPoint(text);
        text = dom.getElementValue(addressElt, "city");
        provider.setCity(text);
        text = dom.getElementValue(addressElt, "administrativeArea");
        provider.setAdministrativeArea(text);
        text = dom.getElementValue(addressElt, "postalCode");
        provider.setPostalCode(text);
        text = dom.getElementValue(addressElt, "country");
        provider.setCountry(text);
        text = dom.getElementValue(addressElt, "electronicMailAddress");
        provider.setEmail(text);
        text = dom.getAttributeValue(respPartyElt, "onlineResource/@href");
        provider.setWebsite(text);
    }
}

