/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows;

import org.vast.ows.AbstractResponseWriter;
import org.vast.ows.OWSException;
import org.vast.ows.OWSIdentification;
import org.vast.ows.OWSServiceCapabilities;
import org.vast.util.ResponsibleParty;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class OWSCapabilitiesWriterV0
extends AbstractResponseWriter<OWSServiceCapabilities> {
    protected abstract void writeContents(DOMHelper var1, Element var2, OWSServiceCapabilities var3, String var4) throws OWSException;

    protected void writeRootAttributes(DOMHelper dom, Element capsElt, OWSServiceCapabilities caps, String version) {
        dom.setAttributeValue(capsElt, "version", version);
        String text = caps.getUpdateSequence();
        if (text != null) {
            dom.setAttributeValue(capsElt, "updateSequence", text);
        }
    }

    protected void writeService(DOMHelper dom, Element capsElt, OWSServiceCapabilities caps) {
        Element serviceElt = dom.addElement((Node)capsElt, "Service");
        OWSCapabilitiesWriterV0.writeIdentification(dom, serviceElt, caps.getIdentification());
        OWSCapabilitiesWriterV0.writeKeywords(dom, serviceElt, caps.getIdentification());
        OWSCapabilitiesWriterV0.writeResponsibleParty(dom, serviceElt, caps.getServiceProvider());
        String text = caps.getFees();
        if (text != null) {
            dom.setElementValue(serviceElt, "fees", text);
        }
        if ((text = caps.getAccessConstraints()) != null) {
            dom.setElementValue(serviceElt, "accessConstraints", text);
        }
    }

    public static void writeIdentification(DOMHelper dom, Element parentElt, OWSIdentification identification) {
        if (identification == null) {
            return;
        }
        String text = identification.getDescription();
        if (text != null) {
            dom.setElementValue(parentElt, "description", text);
        }
        if ((text = identification.getIdentifier()) != null) {
            dom.setElementValue(parentElt, "name", text);
        }
        if ((text = identification.getTitle()) != null) {
            dom.setElementValue(parentElt, "label", text);
        }
    }

    public static void writeKeywords(DOMHelper dom, Element parentElt, OWSIdentification identification) {
        if (!identification.getKeywords().isEmpty()) {
            Element keywordsElt = dom.addElement((Node)parentElt, "keywords");
            int numElts = identification.getKeywords().size();
            for (int i = 0; i < numElts; ++i) {
                String keyword = identification.getKeywords().get(i);
                dom.setElementValue(keywordsElt, "+keyword", keyword);
            }
        }
    }

    public static void writeResponsibleParty(DOMHelper dom, Element capsElt, ResponsibleParty provider) {
        if (provider == null) {
            return;
        }
        Element respPartyElt = dom.addElement((Node)capsElt, "responsibleParty");
        String text = provider.getIndividualName();
        if (text != null) {
            dom.setElementValue(respPartyElt, "individualName", text);
        }
        if ((text = provider.getOrganizationName()) != null) {
            dom.setElementValue(respPartyElt, "organisationName", text);
        }
        if ((text = provider.getPositionName()) != null) {
            dom.setElementValue(respPartyElt, "positionName", text);
        }
        if (provider.hasContactInfo()) {
            Element contactInfoElt = dom.addElement((Node)respPartyElt, "contactInfo");
            text = provider.getVoiceNumber();
            if (text != null) {
                dom.setElementValue(contactInfoElt, "phone/voice", text);
            }
            if ((text = provider.getFaxNumber()) != null) {
                dom.setElementValue(contactInfoElt, "phone/facsimile", text);
            }
            if (provider.hasAddress()) {
                Element addressElt = dom.addElement((Node)contactInfoElt, "address");
                text = provider.getDeliveryPoint();
                if (text != null) {
                    dom.setElementValue(addressElt, "deliveryPoint", text);
                }
                if ((text = provider.getCity()) != null) {
                    dom.setElementValue(addressElt, "city", text);
                }
                if ((text = provider.getAdministrativeArea()) != null) {
                    dom.setElementValue(addressElt, "administrativeArea", text);
                }
                if ((text = provider.getPostalCode()) != null) {
                    dom.setElementValue(addressElt, "postalCode", text);
                }
                if ((text = provider.getCountry()) != null) {
                    dom.setElementValue(addressElt, "country", text);
                }
                if ((text = provider.getEmail()) != null) {
                    dom.setElementValue(addressElt, "electronicMailAddress", text);
                }
            }
        }
    }

    protected void writeCapability(DOMHelper dom, Element capsElt, OWSServiceCapabilities caps) {
        Element opElt;
        String opUrl;
        if (caps.getGetServers().isEmpty() && caps.getPostServers().isEmpty()) {
            return;
        }
        Element requestElt = dom.addElement((Node)capsElt, "Capability/Request");
        for (String opName : caps.getGetServers().keySet()) {
            opUrl = caps.getGetServers().get(opName);
            opElt = dom.addElement((Node)requestElt, opName);
            dom.setAttributeValue(opElt, "DCPType/HTTP/Get/OnlineResource/@xlink:href", opUrl);
            String postUrl = caps.getPostServers().get(opName);
            if (postUrl == null) continue;
            dom.setAttributeValue(opElt, "DCPType/HTTP/Post/OnlineResource/@xlink:href", postUrl);
        }
        for (String opName : caps.getPostServers().keySet()) {
            opUrl = caps.getPostServers().get(opName);
            if (caps.getGetServers().get(opName) != null) continue;
            opElt = dom.addElement((Node)requestElt, opName);
            dom.setAttributeValue(opElt, "DCPType/HTTP/Post/OnlineResource/@xlink:href", opUrl);
        }
    }
}

