/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows;

import org.vast.ows.AbstractResponseWriter;
import org.vast.ows.OWSException;
import org.vast.ows.OWSIdentification;
import org.vast.ows.OWSServiceCapabilities;
import org.vast.util.ResponsibleParty;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class OWSCapabilitiesWriterV11
extends AbstractResponseWriter<OWSServiceCapabilities> {
    protected abstract void writeContents(DOMHelper var1, Element var2, OWSServiceCapabilities var3, String var4) throws OWSException;

    protected void writeRootAttributes(DOMHelper dom, Element capsElt, OWSServiceCapabilities caps, String version) {
        dom.setAttributeValue(capsElt, "version", this.normalizeVersionString(version));
        String text = caps.getUpdateSequence();
        if (text != null) {
            dom.setAttributeValue(capsElt, "updateSequence", text);
        }
    }

    protected String normalizeVersionString(String version) {
        while (version.split("\\.").length < 3) {
            version = version + ".0";
        }
        return version;
    }

    protected void writeServiceIdentification(DOMHelper dom, Element capsElt, OWSServiceCapabilities caps) {
        if (caps.getIdentification() == null) {
            return;
        }
        Element idElt = dom.addElement((Node)capsElt, "ows:ServiceIdentification");
        this.writeIdentification(dom, idElt, caps.getIdentification());
        dom.setElementValue(idElt, "ows:ServiceType", "OGC:" + caps.getService());
        for (String version : caps.getSupportedVersions()) {
            dom.setElementValue(idElt, "+ows:ServiceTypeVersion", version);
        }
        for (String profile : caps.getProfiles()) {
            dom.setElementValue(idElt, "+ows:Profile", profile);
        }
        String text = caps.getFees();
        if (text != null) {
            dom.setElementValue(idElt, "ows:Fees", text);
        }
        if ((text = caps.getAccessConstraints()) != null) {
            dom.setElementValue(idElt, "ows:AccessConstraints", text);
        }
    }

    protected void writeIdentification(DOMHelper dom, Element parentElt, OWSIdentification identification) {
        if (identification == null) {
            return;
        }
        String text = identification.getTitle();
        if (text != null) {
            dom.setElementValue(parentElt, "ows:Title", text);
        }
        if ((text = identification.getDescription()) != null) {
            dom.setElementValue(parentElt, "ows:Abstract", text);
        }
        if (!identification.getKeywords().isEmpty()) {
            Element keywordsElt = dom.addElement((Node)parentElt, "ows:Keywords");
            int numElts = identification.getKeywords().size();
            for (int i = 0; i < numElts; ++i) {
                String keyword = identification.getKeywords().get(i);
                dom.setElementValue(keywordsElt, "+ows:Keyword", keyword);
            }
        }
    }

    protected void writeServiceProvider(DOMHelper dom, Element capsElt, ResponsibleParty provider) {
        if (provider == null) {
            return;
        }
        Element providerElt = dom.addElement((Node)capsElt, "ows:ServiceProvider");
        String text = provider.getOrganizationName();
        dom.setElementValue(providerElt, "ows:ProviderName", text);
        text = provider.getWebsite();
        if (text != null) {
            dom.setAttributeValue(providerElt, "ows:ProviderSite/@xlink:href", text);
        }
        Element contactElt = dom.addElement((Node)providerElt, "ows:ServiceContact");
        text = provider.getIndividualName();
        if (text != null) {
            dom.setElementValue(contactElt, "ows:IndividualName", text);
        }
        if ((text = provider.getPositionName()) != null) {
            dom.setElementValue(contactElt, "ows:PositionName", text);
        }
        if (provider.hasContactInfo()) {
            Element contactInfoElt = dom.addElement((Node)contactElt, "ows:ContactInfo");
            text = provider.getVoiceNumber();
            if (text != null) {
                dom.setElementValue(contactInfoElt, "ows:Phone/ows:Voice", text);
            }
            if ((text = provider.getFaxNumber()) != null) {
                dom.setElementValue(contactInfoElt, "ows:Phone/ows:Facsimile", text);
            }
            if (provider.hasAddress()) {
                Element addressElt = dom.addElement((Node)contactInfoElt, "ows:Address");
                text = provider.getDeliveryPoint();
                if (text != null) {
                    dom.setElementValue(addressElt, "ows:DeliveryPoint", text);
                }
                if ((text = provider.getCity()) != null) {
                    dom.setElementValue(addressElt, "ows:City", text);
                }
                if ((text = provider.getAdministrativeArea()) != null) {
                    dom.setElementValue(addressElt, "ows:AdministrativeArea", text);
                }
                if ((text = provider.getPostalCode()) != null) {
                    dom.setElementValue(addressElt, "ows:PostalCode", text);
                }
                if ((text = provider.getCountry()) != null) {
                    dom.setElementValue(addressElt, "ows:Country", text);
                }
                if ((text = provider.getEmail()) != null) {
                    dom.setElementValue(addressElt, "ows:ElectronicMailAddress", text);
                }
            }
            if ((text = provider.getHoursOfService()) != null) {
                dom.setElementValue(contactInfoElt, "ows:HoursOfService", text);
            }
            if ((text = provider.getContactInstructions()) != null) {
                dom.setElementValue(contactInfoElt, "ows:ContactInstructions", text);
            }
        }
        if ((text = provider.getRole()) != null) {
            dom.setElementValue(contactElt, "ows:Role", text);
        }
    }

    protected void writeOperationsMetadata(DOMHelper dom, Element capsElt, OWSServiceCapabilities caps) {
        Element opElt;
        String opUrl;
        if (caps.getGetServers().isEmpty() && caps.getPostServers().isEmpty()) {
            return;
        }
        Element opsElt = dom.addElement((Node)capsElt, "ows:OperationsMetadata");
        for (String opName : caps.getGetServers().keySet()) {
            opUrl = caps.getGetServers().get(opName);
            opElt = dom.addElement((Node)opsElt, "+ows:Operation");
            dom.setAttributeValue(opElt, "@name", opName);
            dom.setAttributeValue(opElt, "ows:DCP/ows:HTTP/ows:Get/@xlink:href", opUrl);
            String postUrl = caps.getPostServers().get(opName);
            if (postUrl == null) continue;
            dom.setAttributeValue(opElt, "ows:DCP/ows:HTTP/ows:Post/@xlink:href", postUrl);
        }
        for (String opName : caps.getPostServers().keySet()) {
            opUrl = caps.getPostServers().get(opName);
            if (caps.getGetServers().get(opName) != null) continue;
            opElt = dom.addElement((Node)opsElt, "+ows:Operation");
            dom.setAttributeValue(opElt, "@name", opName);
            dom.setAttributeValue(opElt, "ows:DCP/ows:HTTP/ows:Post/@xlink:href", opUrl);
        }
    }
}

