/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows;

import org.vast.ogc.OGCRegistry;
import org.vast.ows.OWSException;
import org.vast.ows.OWSIdentification;
import org.vast.ows.OWSReference;
import org.vast.ows.OWSReferenceGroup;
import org.vast.util.Bbox;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OWSCommonReaderV11 {
    protected static final String invalidCoordinates = "Invalid Coordinates: ";

    public Bbox readBbox(DOMHelper dom, Element bboxElt) throws OWSException {
        Bbox bbox = new Bbox();
        String coordsText = "";
        String crs = dom.getAttributeValue(bboxElt, "@crs");
        bbox.setCrs(crs);
        try {
            coordsText = dom.getElementValue(bboxElt, "LowerCorner");
            String[] coords = coordsText.split(" ");
            bbox.setMinX(Double.parseDouble(coords[0]));
            bbox.setMinY(Double.parseDouble(coords[1]));
            if (coords.length == 3) {
                bbox.setMinZ(Double.parseDouble(coords[2]));
            }
            coordsText = dom.getElementValue(bboxElt, "UpperCorner");
            coords = coordsText.split(" ");
            bbox.setMaxX(Double.parseDouble(coords[0]));
            bbox.setMaxY(Double.parseDouble(coords[1]));
            if (coords.length == 3) {
                bbox.setMaxZ(Double.parseDouble(coords[2]));
            }
        }
        catch (Exception e) {
            throw new OWSException(invalidCoordinates + coordsText, e);
        }
        return bbox;
    }

    public void readReferenceGroup(DOMHelper dom, Element refGroupElt, OWSReferenceGroup refGroup) throws OWSException {
        OWSReference ref;
        Element refElt;
        int j;
        this.readIdentification(dom, refGroupElt, refGroup);
        NodeList refElts = dom.getElements(refGroupElt, "Reference");
        for (j = 0; j < refElts.getLength(); ++j) {
            refElt = (Element)refElts.item(j);
            ref = this.readReference(dom, refElt);
            refGroup.getReferenceList().add(ref);
        }
        refElts = dom.getElements(refGroupElt, "ServiceReference");
        for (j = 0; j < refElts.getLength(); ++j) {
            refElt = (Element)refElts.item(j);
            ref = this.readReference(dom, refElt);
            refGroup.getReferenceList().add(ref);
        }
    }

    public OWSReference readReference(DOMHelper dom, Element refElt) throws OWSException {
        OWSReference ref = new OWSReference();
        String endpoint = dom.getAttributeValue(refElt, "@href");
        ref.setHref(endpoint);
        refElt.removeAttributeNS(OGCRegistry.getNamespaceURI((String)"XLINK"), "href");
        String role = dom.getAttributeValue(refElt, "@role");
        ref.setRole(role);
        String id = dom.getElementValue(refElt, "Identifier");
        ref.setIdentifier(id);
        String desc = dom.getElementValue(refElt, "Abstract");
        ref.setDescription(desc);
        String format = dom.getElementValue(refElt, "Format");
        ref.setFormat(format);
        NodeList metaElts = dom.getElements(refElt, "Metadata/*");
        for (int i = 0; i < metaElts.getLength(); ++i) {
            Element metaElt = (Element)metaElts.item(i).cloneNode(true);
            ref.getMetadata().add(metaElt);
        }
        Element msgElt = dom.getElement(refElt, "RequestMessage/*");
        if (msgElt != null) {
            msgElt = (Element)msgElt.cloneNode(true);
            ref.setRequestXML(msgElt);
        }
        return ref;
    }

    public void readIdentification(DOMHelper dom, Element parentElt, OWSIdentification idObject) throws OWSException {
        this.readDescription(dom, parentElt, idObject);
        String identifier = dom.getElementValue(parentElt, "Identifier");
        idObject.setIdentifier(identifier);
    }

    public void readDescription(DOMHelper dom, Element parentElt, OWSIdentification idObject) throws OWSException {
        String title = dom.getElementValue(parentElt, "Title");
        idObject.setTitle(title);
        String description = dom.getElementValue(parentElt, "Abstract");
        idObject.setDescription(description);
        NodeList keywordElts = dom.getElements(parentElt, "Keywords/Keyword");
        for (int i = 0; i < keywordElts.getLength(); ++i) {
            Element keywordElt = (Element)keywordElts.item(i);
            String keyword = dom.getElementValue(keywordElt);
            idObject.getKeywords().add(keyword);
        }
    }
}

