/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows;

import java.net.URLDecoder;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.vast.ows.OWSException;
import org.vast.util.Bbox;
import org.vast.util.DateTimeFormat;
import org.vast.util.TimeExtent;

public class OWSCommonUtils {
    public static final String invalidReq = "Invalid Request";
    public static final String invalidKVP = "Invalid KVP Request";
    public static final String invalidXML = "Invalid XML Request";
    public static final String invalidValue = "Invalid Value for ";
    protected DateTimeFormat timeFormat = new DateTimeFormat();

    public Map<String, String> parseQueryParameters(String queryString) throws OWSException {
        StringTokenizer st = new StringTokenizer(queryString, "&");
        LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
        while (st.hasMoreTokens()) {
            String nextArg = st.nextToken();
            try {
                int sepIndex = nextArg.indexOf(61);
                String argName = nextArg.substring(0, sepIndex);
                String argValue = nextArg.substring(sepIndex + 1);
                argValue = URLDecoder.decode(argValue, "UTF-8");
                queryParams.put(argName.toLowerCase(), argValue);
            }
            catch (Exception e) {
                throw new OWSException(invalidKVP);
            }
        }
        return queryParams;
    }

    public TimeExtent parseTimeArg(String argValue) throws OWSException {
        TimeExtent timeInfo = new TimeExtent();
        String[] timeRange = argValue.split("/");
        try {
            if (timeRange[0].equalsIgnoreCase("now")) {
                timeInfo.setBaseAtNow(true);
                timeInfo.setBeginNow(true);
                timeInfo.setEndNow(true);
            } else {
                timeInfo.setStartTime(this.timeFormat.parseIso(timeRange[0]));
            }
            if (timeRange.length > 1) {
                if (timeRange[1].equalsIgnoreCase("now")) {
                    timeInfo.setEndNow(true);
                } else {
                    timeInfo.setStopTime(this.timeFormat.parseIso(timeRange[1]));
                }
            }
            if (timeRange.length > 2) {
                timeInfo.setTimeStep(this.timeFormat.parseIsoPeriod(timeRange[2]));
            }
        }
        catch (ParseException e) {
            throw new OWSException("Invalid time argument: " + argValue);
        }
        return timeInfo;
    }

    public Bbox parseBboxArg(String bboxText) throws OWSException {
        Bbox bbox = new Bbox();
        try {
            String[] coords = bboxText.trim().split("[ ,]");
            if (coords.length == 2 || coords.length == 3) {
                bbox.setMinX(Double.parseDouble(coords[0]));
                bbox.setMaxX(Double.parseDouble(coords[1]));
            } else if (coords.length == 4 || coords.length == 5) {
                bbox.setMinX(Double.parseDouble(coords[0]));
                bbox.setMinY(Double.parseDouble(coords[1]));
                bbox.setMaxX(Double.parseDouble(coords[2]));
                bbox.setMaxY(Double.parseDouble(coords[3]));
            } else if (coords.length == 6 || coords.length == 7) {
                bbox.setMinX(Double.parseDouble(coords[0]));
                bbox.setMinY(Double.parseDouble(coords[1]));
                bbox.setMaxX(Double.parseDouble(coords[2]));
                bbox.setMaxY(Double.parseDouble(coords[3]));
                bbox.setMinZ(Double.parseDouble(coords[4]));
                bbox.setMaxZ(Double.parseDouble(coords[5]));
            } else {
                throw new Exception();
            }
            if (coords.length % 2 != 0) {
                String crs = coords[coords.length - 1];
                bbox.setCrs(crs);
            }
            bbox.checkValid();
        }
        catch (Exception e) {
            throw new OWSException("Invalid bbox argument: " + bboxText, e);
        }
        return bbox;
    }

    public double[] parseVector(String vectorText) throws OWSException {
        try {
            String[] elts = vectorText.trim().split("[ ,]");
            double[] vec = new double[elts.length];
            for (int i = 0; i < elts.length; ++i) {
                vec[i] = Double.parseDouble(elts[i]);
            }
            return vec;
        }
        catch (NumberFormatException e) {
            throw new OWSException("Invalid vector argument: " + vectorText, e);
        }
    }
}

