/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows;

import java.util.ArrayList;
import org.vast.ogc.OGCRegistry;
import org.vast.ows.OWSException;
import org.vast.ows.OWSIdentification;
import org.vast.ows.OWSReference;
import org.vast.ows.OWSReferenceGroup;
import org.vast.util.Bbox;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OWSCommonWriterV11 {
    public Element buildBbox(DOMHelper dom, Bbox bbox) throws OWSException {
        dom.addUserPrefix("ows", OGCRegistry.getNamespaceURI((String)"OWS", (String)"1.1"));
        Element bboxElt = dom.createElement("ows:BoundingBox");
        String crs = bbox.getCrs();
        if (crs != null) {
            dom.setAttributeValue(bboxElt, "@crs", crs);
        }
        String lowCoords = Double.toString(bbox.getMinX());
        if (!Double.isNaN(bbox.getMinY())) {
            lowCoords = lowCoords + " " + bbox.getMinY();
        }
        if (!Double.isNaN(bbox.getMinZ())) {
            lowCoords = lowCoords + " " + bbox.getMinZ();
        }
        dom.setElementValue(bboxElt, "ows:LowerCorner", lowCoords);
        String upCoords = Double.toString(bbox.getMaxX());
        if (!Double.isNaN(bbox.getMaxY())) {
            upCoords = upCoords + " " + bbox.getMaxY();
        }
        if (!Double.isNaN(bbox.getMaxZ())) {
            upCoords = upCoords + " " + bbox.getMaxZ();
        }
        dom.setElementValue(bboxElt, "ows:UpperCorner", upCoords);
        return bboxElt;
    }

    public void buildRefGroup(DOMHelper dom, Element refGroupElt, OWSReferenceGroup refGroup) throws OWSException {
        dom.addUserPrefix("ows", OGCRegistry.getNamespaceURI((String)"OWS", (String)"1.1"));
        this.buildIdentification(dom, refGroupElt, refGroup);
        for (int j = 0; j < refGroup.getReferenceList().size(); ++j) {
            OWSReference ref = refGroup.getReferenceList().get(j);
            Element refElt = this.buildReference(dom, ref);
            refGroupElt.appendChild(refElt);
        }
    }

    public Element buildReference(DOMHelper dom, OWSReference ref) throws OWSException {
        String format;
        String desc;
        String identifier;
        String href;
        dom.addUserPrefix("ows", OGCRegistry.getNamespaceURI((String)"OWS", (String)"1.1"));
        dom.addUserPrefix("xlink", OGCRegistry.getNamespaceURI((String)"XLINK"));
        Element requestXML = ref.getRequestXML();
        Element refElt = requestXML != null ? dom.createElement("ows:ServiceReference") : dom.createElement("ows:Reference");
        String role = ref.getRole();
        if (role != null) {
            dom.setAttributeValue(refElt, "@xlink:role", role);
        }
        if ((href = ref.getHref()) != null) {
            dom.setAttributeValue(refElt, "@xlink:href", href);
        }
        if ((identifier = ref.getIdentifier()) != null) {
            dom.setElementValue(refElt, "ows:Identifier", identifier);
        }
        if ((desc = ref.getDescription()) != null) {
            dom.setElementValue(refElt, "ows:Abstract", desc);
        }
        if ((format = ref.getFormat()) != null) {
            dom.setElementValue(refElt, "ows:Format", format);
        }
        for (Object obj : ref.getMetadata()) {
            if (!(obj instanceof Element)) continue;
            Element metaElt = dom.addElement((Node)refElt, "+ows:Metadata");
            Node newElt = refElt.getOwnerDocument().importNode((Element)obj, true);
            metaElt.appendChild(newElt);
        }
        if (requestXML != null) {
            Element msgElt = dom.addElement((Node)refElt, "ows:RequestMessage");
            Node newElt = refElt.getOwnerDocument().importNode(requestXML, true);
            msgElt.appendChild(newElt);
        }
        return refElt;
    }

    public void buildIdentification(DOMHelper dom, Element parentElt, OWSIdentification idObject) throws OWSException {
        dom.addUserPrefix("ows", OGCRegistry.getNamespaceURI((String)"OWS", (String)"1.1"));
        this.buildDescription(dom, parentElt, idObject);
        if (idObject.getIdentifier() != null) {
            dom.setElementValue(parentElt, "ows:Identifier", idObject.getIdentifier());
        }
    }

    public void buildDescription(DOMHelper dom, Element parentElt, OWSIdentification idObject) throws OWSException {
        dom.addUserPrefix("ows", OGCRegistry.getNamespaceURI((String)"OWS", (String)"1.1"));
        if (idObject.getTitle() != null) {
            dom.setElementValue(parentElt, "ows:Title", idObject.getTitle());
        }
        if (idObject.getDescription() != null) {
            dom.setElementValue(parentElt, "ows:Abstract", idObject.getDescription());
        }
        ArrayList<String> keywords = idObject.getKeywords();
        for (int i = 0; i < keywords.size(); ++i) {
            String keyword = (String)keywords.get(i);
            dom.setElementValue(parentElt, "Keywords/+Keyword", keyword);
        }
    }
}

