/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows;

public class OWSException
extends Exception {
    static final long serialVersionUID = -1363920464307597462L;
    public static final String version_nego_failed_code = "VersionNegotiationFailed";
    public static final String version_nego_failed_text = "Version Negotiation Failed";
    public static final String invalid_request_code = "InvalidRequest";
    public static final String invalid_request_text = "Invalid Request";
    public static final String invalid_param_code = "InvalidParameterValue";
    public static final String invalid_param_text = "Invalid Parameter Value: ";
    public static final String missing_param_code = "MissingParameterValue";
    public static final String missing_param_text = "Missing Parameter Value: ";
    public static final String unsupported_op_code = "OperationNotSupported";
    public static final String unsupported_op_text = "Unsupported Operation: ";
    public static final String no_code = "NoApplicableCode";
    public static final String no_code_text = "Internal Error";
    public static final String VERSION_10 = "1.0";
    public static final String VERSION_11 = "1.1.0";
    protected String code;
    protected String locator;
    protected String badValue;
    protected String version;
    protected String soapVersion;

    public OWSException(String message) {
        super(message);
    }

    public OWSException(String code, String locator) {
        this.code = code;
        this.locator = locator;
    }

    public OWSException(String code, String locator, String message) {
        super(message);
        this.code = code;
        this.locator = locator;
    }

    public OWSException(String code, String locator, String badValue, String message) {
        this(code, locator, message);
        this.badValue = badValue;
    }

    public OWSException(Exception e) {
        super(e);
    }

    public OWSException(String message, Exception e) {
        super(message, e);
    }

    public OWSException(String code, String locator, String message, Exception e) {
        super(message, e);
        this.code = code;
        this.locator = locator;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getLocator() {
        return this.locator;
    }

    public void setLocator(String locator) {
        this.locator = locator;
    }

    public String getBadValue() {
        return this.badValue;
    }

    public void setBadValue(String badValue) {
        this.badValue = badValue;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getSoapVersion() {
        return this.soapVersion;
    }

    public void setSoapVersion(String soapVersion) {
        this.soapVersion = soapVersion;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (message != null && !message.equals("")) {
            return message;
        }
        if (this.code == version_nego_failed_code) {
            return version_nego_failed_text;
        }
        if (this.code == invalid_request_code) {
            return invalid_request_text;
        }
        if (this.code == missing_param_code) {
            return missing_param_text + this.locator;
        }
        if (this.code == invalid_param_code) {
            return invalid_param_text + this.locator + (this.badValue == null ? "" : "=" + this.badValue);
        }
        if (this.code == unsupported_op_code) {
            return unsupported_op_text + this.locator;
        }
        if (this.code == no_code) {
            return no_code_text;
        }
        return null;
    }
}

