/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows;

import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OWSExceptionReader {
    public static void checkException(DOMHelper dom, Element elt) throws OWSException {
        OWSException e;
        if (elt.getLocalName().equals("Envelope") && (elt = dom.getElement(elt, "Body/*")).getLocalName().equals("Fault")) {
            elt = dom.getElement(elt, "faultstring");
        }
        if ((e = OWSExceptionReader.readException(dom, elt)) != null) {
            throw e;
        }
    }

    protected static OWSException readException(DOMHelper dom, Element excElt) {
        String eltName = excElt.getLocalName();
        if (eltName.equals("ExceptionReport")) {
            OWSExceptionReport report = new OWSExceptionReport();
            NodeList excElts = dom.getElements(excElt, "Exception");
            for (int i = 0; i < excElts.getLength(); ++i) {
                report.add(OWSExceptionReader.readException(dom, (Element)excElts.item(i)));
            }
            if (report.getExceptionList().size() == 1) {
                return report.getExceptionList().get(0);
            }
            return report;
        }
        if (eltName.equals("Exception")) {
            String exceptionText = dom.getElementValue(excElt, "ExceptionText");
            String code = dom.getAttributeValue(excElt, "exceptionCode");
            String locator = dom.getAttributeValue(excElt, "locator");
            return new OWSException(code, locator, exceptionText);
        }
        if (eltName.equals("ServiceException")) {
            String exceptionText = dom.getElementValue(excElt);
            String code = dom.getAttributeValue(excElt, "code");
            String locator = dom.getAttributeValue(excElt, "Locator");
            return new OWSException(code, locator, exceptionText);
        }
        return null;
    }
}

