/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows;

import java.util.ArrayList;
import java.util.List;
import org.vast.ows.OWSException;

public class OWSExceptionReport
extends OWSException {
    static final long serialVersionUID = 3315748550759133335L;
    protected ArrayList<OWSException> exceptionList;

    public OWSExceptionReport() {
        super("");
        this.version = "1.0";
        this.exceptionList = new ArrayList();
    }

    public OWSExceptionReport(String version) {
        this();
        this.version = version;
    }

    public OWSExceptionReport(OWSException e) {
        this();
        this.version = e.version;
        this.soapVersion = e.soapVersion;
        this.exceptionList.add(e);
    }

    public void add(OWSException e) {
        this.exceptionList.add(e);
    }

    public List<OWSException> getExceptionList() {
        return this.exceptionList;
    }

    @Override
    public String getMessage() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.exceptionList.size(); ++i) {
            OWSException e = this.exceptionList.get(i);
            String code = e.getCode();
            String locator = e.getLocator();
            String text = e.getMessage();
            buf.append("Exception code=\"" + code + "\" locator=\"" + locator + "\" text=" + text + "\n");
        }
        return buf.toString();
    }

    public void process() throws OWSException {
        if (!this.exceptionList.isEmpty()) {
            throw this;
        }
    }
}

