/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.vast.ogc.OGCRegistry;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OWSExceptionWriter {
    protected DOMHelper dom = new DOMHelper();

    public Element buildXML(OWSException e) {
        if (e instanceof OWSExceptionReport) {
            Element detailElt;
            Element faultElt;
            Element envElt;
            OWSExceptionReport report = (OWSExceptionReport)e;
            String version = report.getVersion();
            if (version == null || version.equals("1.0")) {
                this.dom.addUserPrefix("ows", OGCRegistry.getNamespaceURI((String)"OWS"));
            } else {
                this.dom.addUserPrefix("ows", OGCRegistry.getNamespaceURI((String)"OWS", (String)version));
            }
            Element reportElt = this.dom.createElement("ows:ExceptionReport");
            this.dom.setAttributeValue(reportElt, "@version", version);
            List<OWSException> exceptionList = report.getExceptionList();
            for (int i = 0; i < exceptionList.size(); ++i) {
                OWSException exc = exceptionList.get(i);
                String code = exc.getCode();
                String locator = exc.getLocator();
                String text = exc.getMessage();
                Element excElt = this.dom.addElement((Node)reportElt, "+ows:Exception");
                if (code != null) {
                    this.dom.setAttributeValue(excElt, "@exceptionCode", code);
                }
                if (locator != null) {
                    this.dom.setAttributeValue(excElt, "@locator", locator);
                }
                if (text == null) continue;
                this.dom.setElementValue(excElt, "ows:ExceptionText", text);
            }
            OWSException firstExc = report.getExceptionList().get(0);
            String soapVersion = e.getSoapVersion();
            if ("http://schemas.xmlsoap.org/soap/envelope/".equals(soapVersion)) {
                this.dom.addUserPrefix("soap", soapVersion);
                envElt = this.dom.createElement("soap:Envelope");
                faultElt = this.dom.addElement((Node)envElt, "soap:Body/soap:Fault");
                this.dom.setElementValue(faultElt, "soap:faultcode", firstExc.getCode());
                this.dom.setElementValue(faultElt, "soap:faultstring", firstExc.getMessage());
                this.dom.setElementValue(faultElt, "soap:faultactor", "soap:Client");
                detailElt = this.dom.addElement((Node)faultElt, "soap:detail");
                detailElt.appendChild(reportElt.getFirstChild());
                reportElt = envElt;
            } else if ("http://www.w3.org/2003/05/soap-envelope".equals(soapVersion)) {
                this.dom.addUserPrefix("soap", soapVersion);
                envElt = this.dom.createElement("soap:Envelope");
                faultElt = this.dom.addElement((Node)envElt, "soap:Body/soap:Fault");
                this.dom.setElementValue(faultElt, "soap:Code/soap:Value", "soap:Sender");
                this.dom.setElementValue(faultElt, "soap:Code/soap:Subcode/soap:Value", firstExc.getCode());
                this.dom.setElementValue(faultElt, "soap:Reason/soap:Text", firstExc.getMessage());
                detailElt = this.dom.addElement((Node)faultElt, "soap:Detail");
                detailElt.appendChild(reportElt.getFirstChild());
                reportElt = envElt;
            }
            return reportElt;
        }
        return this.buildXML(new OWSExceptionReport(e));
    }

    public void writeException(OutputStream os, OWSException e) {
        try {
            Element reportElt = this.buildXML(e);
            this.dom.serialize((Node)reportElt, os, true);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }
}

