/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.vast.ogc.OGCRegistry;

public class OWSRequest {
    protected static final String EXCEPTION_MIME_TYPE = "application/vnd.ogc.se_xml";
    protected transient HttpServletRequest httpRequest;
    protected transient HttpServletResponse httpResponse;
    protected transient OutputStream outputStream;
    protected String getServer;
    protected String postServer;
    protected String service;
    protected String version;
    protected String operation;
    protected String exceptionType = "application/vnd.ogc.se_xml";
    protected Map<QName, Object> extensions = new HashMap<QName, Object>();
    protected String soapVersion;
    protected int connectTimeOut = 5000;

    public static String checkServer(String url) {
        if (url == null) {
            return null;
        }
        String firstChar = "?";
        if (url.endsWith("&") || url.endsWith("?")) {
            firstChar = "";
        } else if (url.indexOf("?") != -1) {
            firstChar = "&";
        }
        return url + firstChar;
    }

    public OutputStream getResponseStream() {
        if (this.outputStream != null) {
            return this.outputStream;
        }
        try {
            return this.httpResponse.getOutputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setResponseStream(OutputStream os) {
        this.outputStream = os;
    }

    public String getGetServer() {
        return this.getServer;
    }

    public void setGetServer(String getServer) {
        this.getServer = OWSRequest.checkServer(getServer);
    }

    public String getPostServer() {
        return this.postServer;
    }

    public void setPostServer(String postServer) {
        this.postServer = OWSRequest.checkServer(postServer);
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getVersion() {
        return this.version;
    }

    public String getNormalizedVersion() {
        return OGCRegistry.normalizeVersionString((String)this.version);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public void setExceptionType(String exceptionType) {
        this.exceptionType = exceptionType;
    }

    public Map<QName, Object> getExtensions() {
        return this.extensions;
    }

    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    public void setHttpRequest(HttpServletRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public HttpServletResponse getHttpResponse() {
        return this.httpResponse;
    }

    public void setHttpResponse(HttpServletResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public String getSoapVersion() {
        return this.soapVersion;
    }

    public void setSoapVersion(String soapVersion) {
        this.soapVersion = soapVersion;
    }

    public int getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public void setConnectTimeOut(int connectTimeOut) {
        this.connectTimeOut = connectTimeOut;
    }
}

